/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.gui.tables.SimpleColumnListener;
import com.limegroup.gnutella.settings.TablesHandler;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;

public class DefaultColumnPreferenceHandler
implements ColumnPreferenceHandler,
TableColumnModelListener,
MouseListener {
    protected final LimeJTable table;
    protected SimpleColumnListener listener = null;
    protected boolean marginChanged;

    public DefaultColumnPreferenceHandler(LimeJTable limeJTable) {
        this.table = limeJTable;
        this.startListening();
    }

    public void setSimpleColumnListener(SimpleColumnListener simpleColumnListener) {
        this.listener = simpleColumnListener;
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        LimeTableColumn limeTableColumn;
        LimeTableColumn limeTableColumn2 = limeTableColumn = this.getToColumn(tableColumnModelEvent);
        this.setVisibility(limeTableColumn2, true);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n = this.getOrder(limeTableColumn2);
        int n2 = tableColumnModel.getColumnIndex(limeTableColumn2.getId());
        int n3 = tableColumnModel.getColumnCount();
        if (n != n2) {
            this.stopListening();
            n = Math.min(n, n3 - 1);
            tableColumnModel.moveColumn(n2, n);
            for (n2 = n + 1; n2 < n3; ++n2) {
                limeTableColumn2 = (LimeTableColumn)tableColumnModel.getColumn(n2);
                this.setOrder(limeTableColumn2, n2);
            }
            Iterator<LimeTableColumn> iterator = this.table.getHiddenColumns();
            while (iterator.hasNext()) {
                limeTableColumn2 = iterator.next();
                n2 = this.getOrder(limeTableColumn2);
                if (n2 <= n) continue;
                this.setOrder(limeTableColumn2, n2 + 1);
            }
            this.startListening();
        }
        if (this.listener != null) {
            this.listener.columnAdded(limeTableColumn, this.table);
        }
        this.save();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        if (this.table.getTableHeader().getResizingColumn() == null) {
            return;
        }
        this.marginChanged = true;
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        if (tableColumnModelEvent.getFromIndex() == tableColumnModelEvent.getToIndex()) {
            return;
        }
        LimeTableColumn limeTableColumn = this.getFromColumn(tableColumnModelEvent);
        LimeTableColumn limeTableColumn2 = this.getToColumn(tableColumnModelEvent);
        this.setOrder(limeTableColumn, tableColumnModelEvent.getFromIndex());
        this.setOrder(limeTableColumn2, tableColumnModelEvent.getToIndex());
        this.save();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        LimeTableColumn limeTableColumn;
        LimeTableColumn limeTableColumn2;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            limeTableColumn2 = (LimeTableColumn)tableColumnModel.getColumn(i);
            this.setOrder(limeTableColumn2, i);
        }
        limeTableColumn2 = limeTableColumn = this.table.getLastRemovedColumn();
        this.setVisibility(limeTableColumn2, false);
        int n = this.getOrder(limeTableColumn2);
        Iterator<LimeTableColumn> iterator = this.table.getHiddenColumns();
        while (iterator.hasNext()) {
            limeTableColumn2 = iterator.next();
            int n2 = this.getOrder(limeTableColumn2);
            if (n2 <= n) continue;
            this.setOrder(limeTableColumn2, n2 - 1);
        }
        if (this.listener != null) {
            this.listener.columnRemoved(limeTableColumn, this.table);
        }
        this.save();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.marginChanged) {
            return;
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            LimeTableColumn limeTableColumn = (LimeTableColumn)tableColumnModel.getColumn(i);
            this.setWidth(limeTableColumn, limeTableColumn.getWidth());
        }
        this.marginChanged = false;
        this.save();
    }

    public void revertToDefault() {
        int n;
        LimeTableColumn limeTableColumn;
        int n2;
        this.stopListening();
        DataLineModel dataLineModel = (DataLineModel)this.table.getModel();
        for (int i = 0; i < dataLineModel.getColumnCount(); ++i) {
            LimeTableColumn limeTableColumn2 = dataLineModel.getTableColumn(i);
            this.setVisibility(limeTableColumn2, limeTableColumn2.getDefaultVisibility());
            this.setOrder(limeTableColumn2, limeTableColumn2.getDefaultOrder());
            this.setWidth(limeTableColumn2, limeTableColumn2.getDefaultWidth());
            try {
                if (this.table.isColumnVisible(limeTableColumn2.getId())) continue;
                this.table.setColumnVisible(limeTableColumn2.getId(), true);
                if (this.listener == null) continue;
                this.listener.columnAdded(limeTableColumn2, this.table);
                continue;
            }
            catch (LastColumnException lastColumnException) {
                // empty catch block
            }
        }
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (n2 = 0; n2 < dataLineModel.getColumnCount(); ++n2) {
            limeTableColumn = dataLineModel.getTableColumn(n2);
            n = this.getOrder(limeTableColumn);
            int n3 = tableColumnModel.getColumnIndex(limeTableColumn.getId());
            if (n3 != n) {
                tableColumnModel.moveColumn(n3, n);
            }
            limeTableColumn.setPreferredWidth(limeTableColumn.getDefaultWidth());
        }
        for (n2 = 0; n2 < dataLineModel.getColumnCount(); ++n2) {
            limeTableColumn = dataLineModel.getTableColumn(n2);
            n = this.getVisibility(limeTableColumn) ? 1 : 0;
            try {
                if (n != 0) continue;
                this.table.setColumnVisible(limeTableColumn.getId(), false);
                if (this.listener == null) continue;
                this.listener.columnRemoved(limeTableColumn, this.table);
                continue;
            }
            catch (LastColumnException lastColumnException) {
                // empty catch block
            }
        }
        this.startListening();
        this.save();
    }

    public boolean isDefault() {
        DataLineModel dataLineModel = (DataLineModel)this.table.getModel();
        for (int i = 0; i < dataLineModel.getColumnCount(); ++i) {
            LimeTableColumn limeTableColumn = dataLineModel.getTableColumn(i);
            if (!this.isDefaultWidth(limeTableColumn)) {
                return false;
            }
            if (!this.isDefaultOrder(limeTableColumn)) {
                return false;
            }
            if (this.isDefaultVisibility(limeTableColumn)) continue;
            return false;
        }
        return true;
    }

    public void setWidths() {
        this.stopListening();
        DataLineModel dataLineModel = (DataLineModel)this.table.getModel();
        for (int i = 0; i < dataLineModel.getColumnCount(); ++i) {
            LimeTableColumn limeTableColumn = dataLineModel.getTableColumn(i);
            int n = this.getWidth(limeTableColumn);
            if (n == -1) continue;
            limeTableColumn.setPreferredWidth(n);
        }
        this.startListening();
    }

    public void setOrder() {
        this.stopListening();
        boolean bl = false;
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        DataLineModel dataLineModel = (DataLineModel)this.table.getModel();
        int n = dataLineModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            LimeTableColumn limeTableColumn = dataLineModel.getTableColumn(i);
            int n2 = this.getOrder(limeTableColumn);
            if (!this.table.isColumnVisible(limeTableColumn.getId())) continue;
            int n3 = tableColumnModel.getColumnIndex(limeTableColumn.getId());
            if (n2 >= n) {
                n2 = n - 1;
                this.setOrder(limeTableColumn, n2);
                bl = true;
            }
            if (n3 == n2) continue;
            tableColumnModel.moveColumn(n3, n2);
        }
        if (bl) {
            TablesHandler.instance().save();
        }
        this.startListening();
    }

    public void setVisibility() {
        this.stopListening();
        DataLineModel dataLineModel = (DataLineModel)this.table.getModel();
        for (int i = 0; i < dataLineModel.getColumnCount(); ++i) {
            LimeTableColumn limeTableColumn = dataLineModel.getTableColumn(i);
            boolean bl = this.getVisibility(limeTableColumn);
            boolean bl2 = this.table.isColumnVisible(limeTableColumn.getId());
            try {
                if (bl && !bl2) {
                    this.table.setColumnVisible(limeTableColumn.getId(), true);
                    if (this.listener == null) continue;
                    this.listener.columnAdded(limeTableColumn, this.table);
                    continue;
                }
                if (bl || !bl2) continue;
                this.table.setColumnVisible(limeTableColumn.getId(), false);
                if (this.listener == null) continue;
                this.listener.columnRemoved(limeTableColumn, this.table);
                continue;
            }
            catch (LastColumnException lastColumnException) {
                // empty catch block
            }
        }
        this.startListening();
    }

    protected void save() {
        TablesHandler.instance().save();
    }

    protected void startListening() {
        this.table.getTableHeader().addMouseListener(this);
        this.table.getColumnModel().addColumnModelListener(this);
    }

    protected void stopListening() {
        this.table.getTableHeader().removeMouseListener(this);
        this.table.getColumnModel().removeColumnModelListener(this);
    }

    protected LimeTableColumn getToColumn(TableColumnModelEvent tableColumnModelEvent) {
        return (LimeTableColumn)this.table.getColumnModel().getColumn(tableColumnModelEvent.getToIndex());
    }

    protected LimeTableColumn getFromColumn(TableColumnModelEvent tableColumnModelEvent) {
        return (LimeTableColumn)this.table.getColumnModel().getColumn(tableColumnModelEvent.getFromIndex());
    }

    protected void setVisibility(LimeTableColumn limeTableColumn, boolean bl) {
        TablesHandler.getVisibility(limeTableColumn.getId(), limeTableColumn.getDefaultVisibility()).setValue(bl);
    }

    protected void setOrder(LimeTableColumn limeTableColumn, int n) {
        TablesHandler.getOrder(limeTableColumn.getId(), limeTableColumn.getDefaultOrder()).setValue(n);
    }

    protected void setWidth(LimeTableColumn limeTableColumn, int n) {
        TablesHandler.getWidth(limeTableColumn.getId(), limeTableColumn.getDefaultWidth()).setValue(n);
    }

    protected boolean getVisibility(LimeTableColumn limeTableColumn) {
        return TablesHandler.getVisibility(limeTableColumn.getId(), limeTableColumn.getDefaultVisibility()).getValue();
    }

    protected int getOrder(LimeTableColumn limeTableColumn) {
        return TablesHandler.getOrder(limeTableColumn.getId(), limeTableColumn.getDefaultOrder()).getValue();
    }

    protected int getWidth(LimeTableColumn limeTableColumn) {
        return TablesHandler.getWidth(limeTableColumn.getId(), limeTableColumn.getDefaultWidth()).getValue();
    }

    protected boolean isDefaultVisibility(LimeTableColumn limeTableColumn) {
        return TablesHandler.getVisibility(limeTableColumn.getId(), limeTableColumn.getDefaultVisibility()).isDefault();
    }

    protected boolean isDefaultOrder(LimeTableColumn limeTableColumn) {
        return TablesHandler.getOrder(limeTableColumn.getId(), limeTableColumn.getDefaultOrder()).isDefault();
    }

    protected boolean isDefaultWidth(LimeTableColumn limeTableColumn) {
        return TablesHandler.getWidth(limeTableColumn.getId(), limeTableColumn.getDefaultWidth()).isDefault();
    }
}

