/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDataLineModel<T extends DataLine<E>, E>
extends AbstractTableModel
implements DataLineModel<T, E> {
    protected List<T> _list = new ArrayList<T>();
    private static final int ASCENDING = 1;
    private static final int DESCENDING = -1;
    protected int _ascending = 1;
    protected int _activeColumn = -1;
    private final Class<? extends T> _dataLineClass;
    private final T _internalDataLine;
    protected boolean _isSorted = false;

    public BasicDataLineModel(Class<? extends T> clazz) {
        this._dataLineClass = clazz;
        this._internalDataLine = this.createDataLine();
    }

    @Override
    public String[] getToolTipArray(int n, int n2) {
        return ((DataLine)this._list.get(n)).getToolTipArray(n2);
    }

    @Override
    public boolean isTooltipRequired(int n, int n2) {
        return ((DataLine)this._list.get(n)).isTooltipRequired(n2);
    }

    @Override
    public boolean isSortAscending() {
        return this._ascending == 1;
    }

    @Override
    public int getSortColumn() {
        return this._activeColumn;
    }

    @Override
    public boolean isSorted() {
        return this._isSorted;
    }

    @Override
    public void sort(int n) {
        if (n == this._activeColumn) {
            if (this._ascending == -1) {
                this.unsort();
                return;
            }
            this._ascending = -1;
        } else {
            this._ascending = 1;
            this._activeColumn = n;
        }
        this._isSorted = true;
        this.resort();
    }

    @Override
    public void resort() {
        if (this._isSorted) {
            this.doResort();
            this.fireTableDataChanged();
        }
    }

    public void unsort() {
        this._isSorted = false;
        this._activeColumn = -1;
    }

    protected void doResort() {
        Collections.sort(this._list, this);
    }

    @Override
    public boolean needsResort() {
        return this._isSorted && this._internalDataLine.isDynamic(this._activeColumn);
    }

    @Override
    public void clear() {
        this.cleanup();
        this._list.clear();
        this.fireTableDataChanged();
    }

    protected void cleanup() {
        int n = this._list.size();
        for (int i = 0; i < n; ++i) {
            ((DataLine)this._list.get(i)).cleanup();
        }
    }

    @Override
    public Object refresh() {
        int n = this._list.size();
        for (int i = 0; i < n; ++i) {
            ((DataLine)this._list.get(i)).update();
        }
        this.fireTableRowsUpdated(0, n);
        return null;
    }

    @Override
    public int update(E e) {
        int n = this.getRow(e);
        ((DataLine)this._list.get(n)).update();
        this.fireTableRowsUpdated(n, n);
        return n;
    }

    public T createDataLine() {
        try {
            DataLine dataLine = (DataLine)this._dataLineClass.newInstance();
            return (T)dataLine;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException(classCastException);
        }
    }

    public T getNewDataLine(E e) {
        T t = this.createDataLine();
        t.initialize(e);
        return t;
    }

    public int getSortedPosition(T t) {
        int n = Collections.binarySearch(this._list, t, this);
        if (n < 0) {
            n = -(n + 1);
        }
        return n;
    }

    @Override
    public int add(E e) {
        return this.add((T)e, 0);
    }

    @Override
    public int add(E e, int n) {
        T t = this.getNewDataLine(e);
        return t == null ? -1 : this.add(t, n);
    }

    @Override
    public int add(T t) {
        return this.add(t, 0);
    }

    @Override
    public int add(T t, int n) {
        this._list.add(n, t);
        this.fireTableRowsInserted(n, n);
        return n;
    }

    @Override
    public int addSorted(E e) {
        T t = this.getNewDataLine(e);
        return t == null ? -1 : this.add(t, this.getSortedPosition(t));
    }

    @Override
    public int addSorted(T t) {
        return this.add(t, this.getSortedPosition(t));
    }

    @Override
    public T get(int n) {
        if (n == -1) {
            return null;
        }
        return (T)((DataLine)this._list.get(n));
    }

    @Override
    public T get(E e) {
        int n = this.getRow(e);
        if (n != -1) {
            return (T)((DataLine)this._list.get(n));
        }
        return null;
    }

    @Override
    public T get(Object object, int n) {
        int n2 = this.getRow(object, n);
        if (n2 != -1) {
            return (T)((DataLine)this._list.get(n2));
        }
        return null;
    }

    @Override
    public void remove(int n) {
        ((DataLine)this._list.get(n)).cleanup();
        this._list.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    @Override
    public void remove(T t) {
        int n = this._list.indexOf(t);
        if (n != -1) {
            this.remove(n);
        }
    }

    @Override
    public void remove(Object object) {
        int n = this._list.size();
        for (int i = 0; i < n; ++i) {
            if (!((DataLine)this._list.get(i)).getInitializeObject().equals(object)) continue;
            this.remove(i);
            break;
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return ((DataLine)this._list.get(n)).getValueAt(n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n >= 0 && n < this._list.size()) {
            ((DataLine)this._list.get(n)).setValueAt(object, n2);
            this.fireTableRowsUpdated(n, n);
        }
    }

    @Override
    public boolean contains(Object object, int n) {
        int n2 = this._list.size();
        for (int i = 0; i < n2; ++i) {
            if (!((DataLine)this._list.get(i)).getValueAt(n).equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        int n = this._list.size();
        for (int i = 0; i < n; ++i) {
            if (!((DataLine)this._list.get(i)).getInitializeObject().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getRow(T t) {
        return this._list.indexOf(t);
    }

    @Override
    public int getRow(Object object, int n) {
        int n2 = this._list.size();
        for (int i = 0; i < n2; ++i) {
            if (!((DataLine)this._list.get(i)).getValueAt(n).equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getRow(E e) {
        int n = this._list.size();
        for (int i = 0; i < n; ++i) {
            if (!((DataLine)this._list.get(i)).getInitializeObject().equals(e)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int compare(T t, T t2) {
        Object object = t.getValueAt(this._activeColumn);
        Object object2 = t2.getValueAt(this._activeColumn);
        return AbstractTableMediator.compare(object, object2) * this._ascending;
    }

    @Override
    public LimeTableColumn getTableColumn(int n) {
        if (this._internalDataLine == null) {
            return null;
        }
        return this._internalDataLine.getColumn(n);
    }

    @Override
    public int getRowCount() {
        return this._list.size();
    }

    @Override
    public int getColumnCount() {
        if (this._internalDataLine == null) {
            return 0;
        }
        return this._internalDataLine.getColumnCount();
    }

    @Override
    public boolean isClippable(int n) {
        if (this._internalDataLine == null) {
            return false;
        }
        return this._internalDataLine.isClippable(n);
    }

    @Override
    public int getTypeAheadColumn() {
        if (this._internalDataLine == null) {
            return -1;
        }
        return this._internalDataLine.getTypeAheadColumn();
    }

    @Override
    public String getColumnName(int n) {
        return this.getTableColumn(n).getName();
    }

    @Override
    public Object getColumnId(int n) {
        return this.getTableColumn(n).getIdentifier();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return this.getTableColumn(n).getColumnClass();
    }
}

