/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.shell;

import com.limegroup.gnutella.gui.shell.ShellAssociation;
import org.limewire.setting.BooleanSetting;

public class LimeAssociationOption {
    private final ShellAssociation association;
    private final BooleanSetting setting;
    private final String name;
    private final String description;

    public LimeAssociationOption(ShellAssociation shellAssociation, BooleanSetting booleanSetting, String string, String string2) {
        this.association = shellAssociation;
        this.setting = booleanSetting;
        this.name = string;
        this.description = string2;
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            if (!this.isAllowed()) {
                throw new IllegalStateException("cannot enable something that isn't allowed");
            }
            this.association.unregister();
            this.association.register();
        } else if (this.association.isRegistered()) {
            this.association.unregister();
        }
    }

    public boolean isEnabled() {
        return this.association.isRegistered();
    }

    public void setAllowed(boolean bl) {
        if (this.setting != null) {
            this.setting.setValue(bl);
        }
    }

    public boolean isAllowed() {
        return this.setting == null || this.setting.getValue();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isAvailable() {
        return this.association.isAvailable();
    }
}

