/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.gui.search.ThirdPartyResultsDatabase;
import com.limegroup.gnutella.gui.search.ThirdPartySearchResult;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SimpleSpecialResultsDatabaseImpl
implements ThirdPartyResultsDatabase {
    private static final Log LOG = LogFactory.getLog(SimpleSpecialResultsDatabaseImpl.class);
    private final LimeXMLDocumentFactory limeXMLDocumentFactory;

    protected abstract List<Map<String, String>> getSearchResults(String var1);

    protected SimpleSpecialResultsDatabaseImpl(LimeXMLDocumentFactory limeXMLDocumentFactory) {
        this.limeXMLDocumentFactory = limeXMLDocumentFactory;
    }

    @Override
    public final void find(SearchInformation searchInformation, ThirdPartyResultsDatabase.SearchResultsCallback searchResultsCallback) {
        if (!this.beforeFind()) {
            return;
        }
        String string = searchInformation.getQuery();
        this.find(string, searchInformation, searchResultsCallback);
    }

    void find(String string, SearchInformation searchInformation, ThirdPartyResultsDatabase.SearchResultsCallback searchResultsCallback) {
        ArrayList<SearchResult> arrayList = new ArrayList<SearchResult>();
        if (string != null) {
            String string2 = string.toLowerCase();
            List<Map<String, String>> list = this.getSearchResults(string2);
            for (Map<String, String> map : list) {
                Collection<NameValue<String>> collection;
                SearchResult searchResult;
                String string3 = map.get("url");
                int n = (int)this.getOrDefaultWithMax(map, "size", -1L, Integer.MAX_VALUE);
                long l = this.getOrDefaultWithMax(map, "creation_time", 0L, Long.MAX_VALUE);
                String string4 = map.get("vendor");
                String string5 = map.get("name");
                String string6 = map.get("fileType");
                String string7 = map.get("xmlSchema");
                if (string7 == null) {
                    string7 = "audio";
                }
                if ((searchResult = this.newSearchResult(string5, string6, string7, string3, n, l, string4, collection = this.xmlValuesIn(map, string7), string)) == null || string5 == null) continue;
                arrayList.add(searchResult);
            }
        }
        searchResultsCallback.process(arrayList, searchInformation);
    }

    private Collection<NameValue<String>> xmlValuesIn(Map<String, String> map, String string) {
        String string2 = string + "s";
        ArrayList<NameValue<String>> arrayList = new ArrayList<NameValue<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("xml_")) continue;
            arrayList.add(new NameValue<String>(string2 + "__" + string + "__" + entry.getKey().substring(4) + "__", entry.getValue()));
        }
        return arrayList;
    }

    protected boolean beforeFind() {
        return true;
    }

    private SearchResult newSearchResult(String string, String string2, String string3, String string4, int n, long l, String string5, Collection<NameValue<String>> collection, String string6) {
        LimeXMLDocument limeXMLDocument = null;
        if (collection.size() > 0) {
            try {
                limeXMLDocument = this.limeXMLDocumentFactory.createLimeXMLDocument(collection, "http://www.limewire.com/schemas/" + string3 + ".xsd");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.error("error creating document", illegalArgumentException);
            }
        }
        return new ThirdPartySearchResult(string, string2, string4, n, l, limeXMLDocument, string5, string6);
    }

    private long getOrDefaultWithMax(Map<String, String> map, String string, long l, long l2) {
        String string2 = map.get(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Math.min(l2, Long.parseLong(string2));
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    protected static final class Attr {
        static final String XML_SCHEMA = "xmlSchema";
        static final String URL = "url";
        static final String SIZE = "size";
        static final String CREATION_TIME = "creation_time";
        static final String VENDOR = "vendor";
        static final String NAME = "name";
        static final String FILE_TYPE = "fileType";

        private Attr() {
        }
    }
}

