/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.settings.LimeWireSettings;
import java.util.HashMap;
import java.util.Map;
import org.limewire.setting.SettingsFactory;
import org.limewire.setting.StringSetting;

class SelectorsHandler
extends LimeWireSettings {
    private static final SelectorsHandler INSTANCE = new SelectorsHandler();
    private static final SettingsFactory FACTORY = INSTANCE.getFactory();
    private static final Map<String, SelectorSettingPair> FILTERS = new HashMap<String, SelectorSettingPair>();

    public static SelectorsHandler instance() {
        return INSTANCE;
    }

    private SelectorsHandler() {
        super("filters.props", "FrostWire Filters File");
    }

    public static Selector getSelector(String string, int n) {
        String string2 = string + "_" + n;
        SelectorSettingPair selectorSettingPair = FILTERS.get(string2);
        if (selectorSettingPair == null) {
            selectorSettingPair = SelectorsHandler.addDefault(string, n);
        }
        return selectorSettingPair.selector;
    }

    public static void setSelector(String string, int n, Selector selector) {
        String string2 = string + "_" + n;
        SelectorSettingPair selectorSettingPair = FILTERS.get(string2);
        if (selectorSettingPair == null) {
            selectorSettingPair = SelectorsHandler.addDefault(string, n);
        }
        StringSetting stringSetting = selectorSettingPair.setting;
        stringSetting.setValue(selector.toString());
        FILTERS.put(string2, new SelectorSettingPair(selector, stringSetting));
    }

    private static SelectorSettingPair addDefault(String string, int n) {
        String string2 = string + "_" + n;
        Selector selector = SelectorsHandler.getDefaultSelector(string, n);
        StringSetting stringSetting = FACTORY.createStringSetting(string2, selector.toString());
        try {
            selector = Selector.createFromString(stringSetting.getValue());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        SelectorSettingPair selectorSettingPair = new SelectorSettingPair(selector, stringSetting);
        FILTERS.put(string2, selectorSettingPair);
        return selectorSettingPair;
    }

    private static Selector getDefaultSelector(String string, int n) {
        if ("*".equals(string)) {
            switch (n) {
                case 0: {
                    return Selector.createSchemaSelector();
                }
                case 1: {
                    return Selector.createFieldSelector("audio", "audios__audio__artist__");
                }
                case 2: {
                    return Selector.createFieldSelector("audio", "audios__audio__album__");
                }
            }
        } else if ("audio".equals(string)) {
            switch (n) {
                case 0: {
                    return Selector.createFieldSelector("audio", "audios__audio__genre__");
                }
                case 1: {
                    return Selector.createFieldSelector("audio", "audios__audio__artist__");
                }
                case 2: {
                    return Selector.createFieldSelector("audio", "audios__audio__album__");
                }
            }
        } else if ("video".equals(string)) {
            switch (n) {
                case 0: {
                    return Selector.createPropertySelector(Selector.PropertyType.TYPE);
                }
                case 1: {
                    return Selector.createFieldSelector("video", "videos__video__type__");
                }
                case 2: {
                    return Selector.createFieldSelector("video", "videos__video__rating__");
                }
            }
        } else {
            switch (n) {
                case 0: {
                    return Selector.createSchemaSelector();
                }
                case 1: {
                    return Selector.createPropertySelector(Selector.PropertyType.TYPE);
                }
                case 2: {
                    return Selector.createPropertySelector(Selector.PropertyType.SPEED);
                }
            }
        }
        throw new IllegalArgumentException("invalid depth: " + n);
    }

    private static class SelectorSettingPair {
        private final Selector selector;
        private final StringSetting setting;

        SelectorSettingPair(Selector selector, StringSetting stringSetting) {
            this.selector = selector;
            this.setting = stringSetting;
        }
    }
}

