/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.FilterBox;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.Selector;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class SelectorMenu {
    private static final String SELECTOR = "selector";
    private final JPopupMenu MENU = new JPopupMenu();

    SelectorMenu(FilterBox filterBox) {
        SelectionListener selectionListener = new SelectionListener(filterBox);
        List list = filterBox.getMetadataModel().getSelectorOptions();
        String string = "";
        JMenu jMenu = null;
        for (Selector selector : list) {
            JMenuItem jMenuItem = this.createItem(filterBox, selector);
            jMenuItem.addActionListener(selectionListener);
            if (selector.isFieldSelector()) {
                if (!selector.getSchema().equals(string)) {
                    string = selector.getSchema();
                    String string2 = NamedMediaType.getFromDescription(string).getName();
                    jMenu = new JMenu(string2);
                    this.MENU.add(jMenu);
                }
                assert (jMenu != null);
                jMenu.add(jMenuItem);
                continue;
            }
            this.MENU.add(jMenuItem);
        }
    }

    JPopupMenu getComponent() {
        return this.MENU;
    }

    private JMenuItem createItem(FilterBox filterBox, Selector selector) {
        String string = selector.getTitle();
        boolean bl = filterBox.getSelector().equals(selector);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, bl);
        jCheckBoxMenuItem.putClientProperty(SELECTOR, selector);
        return jCheckBoxMenuItem;
    }

    private static class SelectionListener
    implements ActionListener {
        private final FilterBox BOX;

        SelectionListener(FilterBox filterBox) {
            this.BOX = filterBox;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            Selector selector = (Selector)jMenuItem.getClientProperty(SelectorMenu.SELECTOR);
            this.BOX.setSelector(selector);
        }
    }
}

