/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.EndpointHolder;
import com.limegroup.gnutella.gui.search.QualityHolder;
import com.limegroup.gnutella.gui.search.ResultNameHolder;
import com.limegroup.gnutella.gui.search.SearchColumn;
import com.limegroup.gnutella.gui.search.XMLSearchColumn;
import com.limegroup.gnutella.gui.tables.ChatHolder;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.licenses.License;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SearchTableColumns {
    static final int QUALITY_IDX = 0;
    private final LimeTableColumn QUALITY_COLUMN = new SearchColumn(0, "RESULT_PANEL_QUALITY", I18n.tr("Quality"), 55, true, QualityHolder.class);
    static final int COUNT_IDX = 1;
    private final LimeTableColumn COUNT_COLUMN = new SearchColumn(1, "RESULT_PANEL_COUNT", I18n.tr("#"), 24, true, Integer.class);
    static final int LICENSE_IDX = 2;
    private final LimeTableColumn LICENSE_COLUMN = new SearchColumn(2, "RESULT_PANEL_LICENSE", I18n.tr("License"), 40, true, License.class);
    static final int ICON_IDX = 3;
    private final LimeTableColumn ICON_COLUMN = new SearchColumn(3, "RESULT_PANEL_ICON", I18n.tr("Icon"), GUIMediator.getThemeImage("question_mark"), 18, true, Icon.class);
    static final int NAME_IDX = 4;
    private final LimeTableColumn NAME_COLUMN = new SearchColumn(4, "RESULT_PANEL_NAME", I18n.tr("Name"), 272, true, ResultNameHolder.class);
    static final int TYPE_IDX = 5;
    private final LimeTableColumn TYPE_COLUMN = new SearchColumn(5, "RESULT_PANEL_TYPE", I18n.tr("Type"), 42, true, String.class);
    static final int SIZE_IDX = 6;
    private final LimeTableColumn SIZE_COLUMN = new SearchColumn(6, "RESULT_PANEL_SIZE", I18n.tr("Size"), 53, true, String.class);
    static final int SPEED_IDX = 7;
    private final LimeTableColumn SPEED_COLUMN = new SearchColumn(7, "RESULT_PANEL_SPEED", I18n.tr("Speed"), 61, true, String.class);
    static final int CHAT_IDX = 8;
    private final LimeTableColumn CHAT_COLUMN = new SearchColumn(8, "RESULT_PANEL_CHAT", I18n.tr("Chat"), 40, false, ChatHolder.class);
    static final int LOCATION_IDX = 9;
    private final LimeTableColumn LOCATION_COLUMN = new SearchColumn(9, "RESULT_PANEL_LOCATION", I18n.tr("Location"), 86, false, EndpointHolder.class);
    static final int VENDOR_IDX = 10;
    private final LimeTableColumn VENDOR_COLUMN = new SearchColumn(10, "RESULT_PANEL_VENDOR", I18n.tr("Vendor"), 55, false, String.class);
    static final int ADDED_IDX = 11;
    private final LimeTableColumn ADDED_COLUMN = new SearchColumn(11, "RESULT_PANEL_ADDED", I18n.tr("Created"), 55, false, Date.class);
    static final int SPAM_IDX = 12;
    private final LimeTableColumn SPAM_COLUMN = new SearchColumn(12, "RESULT_PANEL_SPAM", I18n.tr("Junk Rating"), 40, false, Float.class);
    static final int DEFAULT_COLUMN_COUNT = 13;
    static final int EXTRA_COLUMN_COUNT;
    private final List<XMLSearchColumn> EXTRA_COLUMNS = new ArrayList<XMLSearchColumn>();
    static final int COLUMN_COUNT;

    SearchTableColumns() {
        SearchTableColumns.addColumns(this.EXTRA_COLUMNS);
    }

    private static void addColumns(List<? super XMLSearchColumn> list) {
        Collection<LimeXMLSchema> collection = GuiCoreMediator.getLimeXMLSchemaRepository().getAvailableSchemas();
        int n = 13;
        for (LimeXMLSchema limeXMLSchema : collection) {
            for (SchemaFieldInfo schemaFieldInfo : limeXMLSchema.getCanonicalizedFields()) {
                if (schemaFieldInfo.isHidden()) continue;
                XMLSearchColumn xMLSearchColumn = new XMLSearchColumn(n, schemaFieldInfo);
                list.add(xMLSearchColumn);
                ++n;
            }
        }
    }

    LimeTableColumn getColumn(int n) {
        switch (n) {
            case 0: {
                return this.QUALITY_COLUMN;
            }
            case 1: {
                return this.COUNT_COLUMN;
            }
            case 3: {
                return this.ICON_COLUMN;
            }
            case 4: {
                return this.NAME_COLUMN;
            }
            case 5: {
                return this.TYPE_COLUMN;
            }
            case 6: {
                return this.SIZE_COLUMN;
            }
            case 7: {
                return this.SPEED_COLUMN;
            }
            case 8: {
                return this.CHAT_COLUMN;
            }
            case 9: {
                return this.LOCATION_COLUMN;
            }
            case 10: {
                return this.VENDOR_COLUMN;
            }
            case 11: {
                return this.ADDED_COLUMN;
            }
            case 2: {
                return this.LICENSE_COLUMN;
            }
            case 12: {
                return this.SPAM_COLUMN;
            }
        }
        if (n == -1 && SearchSettings.moveJunkToBottom()) {
            return this.QUALITY_COLUMN;
        }
        if (n >= 13 && n < COLUMN_COUNT) {
            return this.EXTRA_COLUMNS.get(n - 13);
        }
        throw new IllegalStateException("illegal idx: " + n);
    }

    static {
        LinkedList linkedList = new LinkedList();
        SearchTableColumns.addColumns(linkedList);
        EXTRA_COLUMN_COUNT = linkedList.size();
        COLUMN_COUNT = EXTRA_COLUMN_COUNT + 13;
    }
}

