/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.NetworkManager;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ClearableAutoCompleteTextField;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.KeyProcessingTextField;
import com.limegroup.gnutella.gui.MySharedFilesButton;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.SchemaBox;
import com.limegroup.gnutella.gui.search.SearchField;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.gui.xml.InputPanel;
import com.limegroup.gnutella.settings.FilterSettings;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchInputPanel
extends JPanel {
    private final JLabel WHATSNEW_SEARCH_LABEL = new JLabel();
    private final JLabel SEARCH_TYPE_LABEL = new JLabel();
    private final SearchField SEARCH_FIELD = new SearchField(14);
    private final JTextArea IP_TEXT = new JTextArea();
    private final AutoCompleteTextField BROWSE_HOST_FIELD = new ClearableAutoCompleteTextField();
    private final JButton WHATSNEW = new JButton(I18n.tr("What's New"));
    private final JTabbedPane PANE = new JTabbedPane(3);
    private final CardLayout META_CARDS = new CardLayout();
    private final JPanel META_PANEL = new JPanel(this.META_CARDS);
    private static final String DEFAULT_PANEL_KEY = "defaultPanel";
    private final SchemaBox SCHEMA_BOX = new SchemaBox();
    private final Ditherer DITHERER = new Ditherer(62, ThemeFileHandler.SEARCH_PANEL_BG_1.getValue(), ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
    private JPanel searchEntry;
    private final ActionListener SEARCH_LISTENER = new SearchListener();
    private Set<String> inputPanelKeys = null;
    private Map<NamedMediaType, Dimension> inputPanelDimensions = new HashMap<NamedMediaType, Dimension>();
    private final NetworkManager networkManager;
    private final NetworkInstanceUtils networkInstanceUtils;

    SearchInputPanel(NetworkManager networkManager, NetworkInstanceUtils networkInstanceUtils) {
        super(new BorderLayout(0, 5));
        this.networkManager = networkManager;
        this.networkInstanceUtils = networkInstanceUtils;
        SchemaListener schemaListener = new SchemaListener();
        this.SCHEMA_BOX.addSelectionListener(schemaListener);
        this.add((Component)this.SCHEMA_BOX, "North");
        this.searchEntry = this.createSearchEntryPanel();
        JPanel jPanel = this.createWhatIsNewPanel();
        JPanel jPanel2 = this.createBrowseHostPanel();
        this.panelize(this.searchEntry);
        this.panelize(jPanel);
        this.panelize(jPanel2);
        this.PANE.add(I18n.tr("Keyword"), this.searchEntry);
        this.PANE.add(I18n.tr("What's New"), jPanel);
        this.PANE.add(I18n.tr("Direct Connect"), jPanel2);
        this.PANE.setRequestFocusEnabled(false);
        this.PANE.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SearchInputPanel.this.requestSearchFocusImmediately();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        if (!ThemeSettings.isNativeTheme()) {
            this.PANE.setBorder(new LineBorder(ThemeFileHandler.SEARCH_GRID_COLOR.getValue()){

                public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    try {
                        Component component2 = SearchInputPanel.this.PANE.getSelectedComponent();
                        if (component2 != null) {
                            n4 = component2.getBounds().height + 4;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                    super.paintBorder(component, graphics, n, n2, n3, n4);
                }
            });
        }
        this.add((Component)this.PANE, "Center");
        BoxPanel boxPanel = new BoxPanel(0);
        boxPanel.add(new JLabel(GUIMediator.getThemeImage("shared_folder")));
        boxPanel.add(Box.createHorizontalStrut(5));
        boxPanel.add(new MySharedFilesButton());
        boxPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 0));
        this.add((Component)boxPanel, "South");
        this.WHATSNEW_SEARCH_LABEL.setFont(UIManager.getFont("Table.font.bold"));
        Font font = UIManager.getFont("Table.font.bold");
        Font font2 = new Font(font.getName(), font.getStyle(), font.getSize() + 5);
        this.SEARCH_TYPE_LABEL.setFont(font2);
        this.SEARCH_TYPE_LABEL.setPreferredSize(new Dimension(130, 20));
        schemaListener.actionPerformed(null);
    }

    KeyProcessingTextField getForwardingSearchField() {
        if (this.isNormalSearchType()) {
            if (this.SCHEMA_BOX.getSelectedSchema() != null) {
                return this.getInputPanel().getFirstTextField();
            }
            return this.SEARCH_FIELD;
        }
        if (this.isBrowseHostSearchType()) {
            return this.BROWSE_HOST_FIELD;
        }
        return null;
    }

    boolean isKeyEventForwardable() {
        return this.isNormalSearchType() || this.isBrowseHostSearchType();
    }

    boolean isBrowseHostSearchType() {
        return this.PANE.getSelectedIndex() == 2;
    }

    boolean isWhatIsNewSearchType() {
        return this.PANE.getSelectedIndex() == 1;
    }

    boolean isNormalSearchType() {
        return this.PANE.getSelectedIndex() == 0;
    }

    void addressChanged() {
        this.updateIpText();
        this.invalidate();
        this.revalidate();
    }

    void requestSearchFocusImmediately() {
        if (this.isNormalSearchType()) {
            if (this.SCHEMA_BOX.getSelectedSchema() != null) {
                this.getInputPanel().requestFirstFocus();
            } else {
                this.SEARCH_FIELD.requestFocus();
            }
        } else if (this.isWhatIsNewSearchType()) {
            this.WHATSNEW.requestFocus();
        } else if (this.isBrowseHostSearchType()) {
            this.BROWSE_HOST_FIELD.requestFocus();
        }
    }

    void requestSearchFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchInputPanel.this.requestSearchFocusImmediately();
            }
        });
    }

    private void panelize(JComponent jComponent) {
        GUIUtils.setOpaque(false, jComponent);
        if (!ThemeSettings.isNativeTheme()) {
            jComponent.setOpaque(true);
        }
        jComponent.setBackground(ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
    }

    private JPanel createBrowseHostPanel() {
        this.BROWSE_HOST_FIELD.addActionListener(this.SEARCH_LISTENER);
        DitherPanel ditherPanel = new DitherPanel(this.DITHERER);
        ditherPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        JLabel jLabel = new JLabel(I18n.tr("Got Friends?"));
        jLabel.setFont(UIManager.getFont("Table.font.bold"));
        ditherPanel.add((Component)jLabel, gridBagConstraints);
        JTextArea jTextArea = new JTextArea(I18n.tr("Enter the IP address and port number (i.e. ip:port) of a friend you'd like to connect to, click 'Direct Connect', and FrostWire will try to browse that user's shared files."));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setColumns(15);
        jTextArea.setEditable(false);
        jTextArea.setFont(UIManager.getFont("Table.font"));
        jTextArea.setForeground(jLabel.getForeground());
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        ditherPanel.add((Component)jTextArea, gridBagConstraints);
        this.updateIpText();
        this.IP_TEXT.setLineWrap(true);
        this.IP_TEXT.setWrapStyleWord(true);
        this.IP_TEXT.setColumns(15);
        this.IP_TEXT.setEditable(false);
        this.IP_TEXT.setFont(UIManager.getFont("Table.font"));
        this.IP_TEXT.setForeground(jLabel.getForeground());
        ditherPanel.add((Component)this.IP_TEXT, gridBagConstraints);
        gridBagConstraints.fill = 2;
        ditherPanel.add((Component)this.BROWSE_HOST_FIELD, gridBagConstraints);
        JButton jButton = new JButton(I18n.tr("Direct Connect"));
        jButton.addActionListener(this.SEARCH_LISTENER);
        gridBagConstraints.fill = 0;
        ditherPanel.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        ditherPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        return ditherPanel;
    }

    private void updateIpText() {
        if (this.networkManager.acceptedIncomingConnection() && !this.networkInstanceUtils.isPrivate()) {
            this.IP_TEXT.setText(I18n.tr("When your friends want to connect to you, they should enter") + " \"" + NetworkUtils.ip2string(this.networkManager.getAddress()) + ":" + this.networkManager.getPort() + "\"");
        } else {
            this.IP_TEXT.setText(I18n.tr("Your computer is behind a firewall or router and cannot receive direct connections."));
        }
    }

    private JPanel createWhatIsNewPanel() {
        DitherPanel ditherPanel = new DitherPanel(this.DITHERER);
        ditherPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        JLabel jLabel = new JLabel(I18n.tr("Don't Know"));
        jLabel.setFont(UIManager.getFont("Table.font.bold"));
        ditherPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel(I18n.tr("What To Look For?"));
        jLabel2.setFont(UIManager.getFont("Table.font.bold"));
        ditherPanel.add((Component)jLabel2, gridBagConstraints);
        JTextArea jTextArea = new JTextArea(I18n.tr("A \"What's New\" search will search for files that have been recently added to the network."));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setColumns(15);
        jTextArea.setEditable(false);
        jTextArea.setFont(UIManager.getFont("Table.font"));
        jTextArea.setForeground(jLabel.getForeground());
        gridBagConstraints.insets = new Insets(15, 0, 30, 0);
        ditherPanel.add((Component)jTextArea, gridBagConstraints);
        JTextArea jTextArea2 = new JTextArea(I18n.tr("Current Search:") + "  ");
        jTextArea2.setFont(UIManager.getFont("Table.font"));
        jTextArea2.setEditable(false);
        jTextArea2.setForeground(jLabel.getForeground());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ditherPanel.add((Component)jTextArea2, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        ditherPanel.add((Component)this.WHATSNEW_SEARCH_LABEL, gridBagConstraints);
        this.WHATSNEW.addActionListener(this.SEARCH_LISTENER);
        gridBagConstraints.insets = new Insets(5, 0, 30, 0);
        gridBagConstraints.anchor = 10;
        ditherPanel.add((Component)this.WHATSNEW, gridBagConstraints);
        final JCheckBox jCheckBox = new JCheckBox(I18n.tr("Hide Adult Content"), FilterSettings.FILTER_WHATS_NEW_ADULT.getValue());
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FilterSettings.FILTER_WHATS_NEW_ADULT.setValue(jCheckBox.isSelected());
            }
        });
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        ditherPanel.add((Component)jCheckBox, gridBagConstraints);
        jCheckBox.setVisible(!FilterSettings.FILTER_ADULT.getValue());
        gridBagConstraints.weighty = 1.0;
        ditherPanel.add(Box.createVerticalGlue(), gridBagConstraints);
        return ditherPanel;
    }

    private JPanel createSearchEntryPanel() {
        this.SEARCH_FIELD.addActionListener(this.SEARCH_LISTENER);
        this.META_PANEL.add((Component)this.createDefaultSearchPanel(), DEFAULT_PANEL_KEY);
        DitherPanel ditherPanel = new DitherPanel(this.DITHERER);
        ditherPanel.setLayout(new BoxLayout(ditherPanel, 1));
        ditherPanel.add(GUIUtils.left(this.SEARCH_TYPE_LABEL));
        ditherPanel.add(Box.createVerticalStrut(5));
        ditherPanel.add(this.META_PANEL);
        return ditherPanel;
    }

    private void createInputPanelForNamedMediaType(NamedMediaType namedMediaType) {
        String string = namedMediaType.getName();
        LimeXMLSchema limeXMLSchema = namedMediaType.getSchema();
        if (limeXMLSchema == null) {
            throw new NullPointerException("named mediatype has no schema");
        }
        InputPanel inputPanel = new InputPanel(limeXMLSchema, this.SEARCH_LISTENER, this.SEARCH_FIELD.getDocument(), this.SEARCH_FIELD.getUndoManager());
        inputPanel.addMoreOptionsListener(new MoreOptionsListener());
        JScrollPane jScrollPane = new JScrollPane(inputPanel, 20, 31);
        this.cleanupPaneActions(jScrollPane.getActionMap());
        jScrollPane.setOpaque(false);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.getViewport().setBorder(null);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)this.createSearchButtonPanel(), "South");
        int n = (int)jScrollPane.getPreferredSize().getWidth();
        int n2 = (int)jScrollPane.getPreferredSize().getHeight();
        Dimension dimension = new Dimension(n + 70, n2 + 30);
        jPanel.setMaximumSize(dimension);
        this.inputPanelDimensions.put(namedMediaType, dimension);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jPanel);
        this.getInputPanelKeys().add(string);
        this.META_PANEL.add((Component)jPanel2, string);
        this.panelize(this.searchEntry);
    }

    private void cleanupPaneActions(ActionMap actionMap) {
        if (actionMap == null) {
            return;
        }
        Object[] objectArray = actionMap.allKeys();
        for (int i = 0; i < objectArray.length; ++i) {
            Action action = actionMap.get(objectArray[i]);
            if (action == null) continue;
            Object object = action.getValue("Name");
            if (!(object instanceof String)) {
                return;
            }
            String string = (String)object;
            if (!string.equals("scrollHome") && !string.equals("scrollEnd") && !string.equals("scrollLeft") && !string.equals("scrollRight") && !string.equals("unitScrollLeft") && !string.equals("unitScrollRight")) continue;
            actionMap.remove(objectArray[i]);
            if (actionMap.get(objectArray[i]) == null) continue;
            this.cleanupPaneActions(actionMap.getParent());
        }
    }

    private Set<String> getInputPanelKeys() {
        if (this.inputPanelKeys == null) {
            this.inputPanelKeys = new HashSet<String>();
        }
        return this.inputPanelKeys;
    }

    private JPanel createDefaultSearchPanel() {
        JPanel jPanel = this.createLabel(I18n.tr("Filename"));
        BoxPanel boxPanel = new BoxPanel(1);
        boxPanel.add(jPanel);
        boxPanel.add(Box.createVerticalStrut(3));
        boxPanel.add(GUIUtils.left(this.SEARCH_FIELD));
        boxPanel.add(Box.createVerticalStrut(5));
        boxPanel.add(this.createSearchButtonPanel());
        return GUIUtils.left(boxPanel);
    }

    private JPanel createLabel(String string) {
        BoxPanel boxPanel = new BoxPanel(0);
        boxPanel.setOpaque(false);
        boxPanel.add(new JLabel(string));
        boxPanel.add(Box.createHorizontalGlue());
        return boxPanel;
    }

    private JPanel createSearchButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
        JButton jButton = new JButton(I18n.tr("Search"));
        jButton.setToolTipText(I18n.tr("Search the Network for the Given Words"));
        jButton.addActionListener(this.SEARCH_LISTENER);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        return jPanel;
    }

    private JComponent getVisibleComponent() {
        for (int i = 0; i < this.META_PANEL.getComponentCount(); ++i) {
            Component component = this.META_PANEL.getComponent(i);
            if (!component.isVisible()) continue;
            return (JComponent)component;
        }
        return null;
    }

    private JScrollPane getVisibleScrollPane() {
        JComponent jComponent = (JComponent)this.getVisibleComponent().getComponent(0);
        for (int i = 0; i < jComponent.getComponentCount(); ++i) {
            Component component = jComponent.getComponent(i);
            if (!component.isVisible() || !(component instanceof JScrollPane)) continue;
            return (JScrollPane)component;
        }
        return null;
    }

    private InputPanel getInputPanel() {
        JScrollPane jScrollPane = this.getVisibleScrollPane();
        if (jScrollPane == null) {
            return null;
        }
        return (InputPanel)jScrollPane.getViewport().getView();
    }

    private class MoreOptionsListener
    implements ActionListener {
        private MoreOptionsListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            JComponent jComponent = (JComponent)SearchInputPanel.this.getVisibleComponent().getComponent(0);
            JComponent jComponent2 = (JComponent)((JComponent)jComponent.getComponent(0)).getComponent(0);
            if (jComponent instanceof JPanel && jComponent2 instanceof JViewport) {
                if (jCheckBox.isSelected()) {
                    jComponent.setMaximumSize(null);
                } else {
                    Dimension dimension = (Dimension)SearchInputPanel.this.inputPanelDimensions.get(SearchInputPanel.this.SCHEMA_BOX.getSelectedMedia());
                    if (dimension != null) {
                        jComponent.setMaximumSize(dimension);
                    }
                }
            }
            SearchInputPanel.this.invalidate();
            SearchInputPanel.this.revalidate();
            SearchInputPanel.this.repaint();
        }
    }

    private class SearchListener
    implements ActionListener {
        private SearchListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchInformation searchInformation;
            MediaType mediaType = SearchInputPanel.this.SCHEMA_BOX.getSelectedMediaType();
            InputPanel inputPanel = null;
            if (SearchInputPanel.this.isWhatIsNewSearchType()) {
                searchInformation = SearchInformation.createWhatsNewSearch(SearchInputPanel.this.SCHEMA_BOX.getSelectedItem(), mediaType);
            } else if (SearchInputPanel.this.isNormalSearchType()) {
                String string = null;
                String string2 = null;
                String string3 = null;
                if (SearchInputPanel.this.SCHEMA_BOX.getSelectedSchema() != null) {
                    inputPanel = SearchInputPanel.this.getInputPanel();
                    string = inputPanel.getStandardQuery();
                    string2 = inputPanel.getInput(true);
                    string3 = inputPanel.getTitleForQuery();
                } else {
                    string3 = string = SearchInputPanel.this.SEARCH_FIELD.getText();
                }
                searchInformation = SearchInformation.createTitledKeywordSearch(string, string2, mediaType, string3);
            } else if (SearchInputPanel.this.isBrowseHostSearchType()) {
                String string = SearchInputPanel.this.BROWSE_HOST_FIELD.getText();
                if (!NetworkUtils.isAddress(string)) {
                    GUIMediator.showError(I18n.tr("The address format is incorrect, please use host:port."));
                    return;
                }
                searchInformation = SearchInformation.createBrowseHostSearch(string);
                mediaType = MediaType.getAnyTypeMediaType();
            } else {
                throw new IllegalStateException("Invalid search: " + actionEvent);
            }
            if (SearchMediator.triggerSearch(searchInformation) != null) {
                if (searchInformation.isKeywordSearch()) {
                    if (inputPanel != null) {
                        inputPanel.storeInput();
                        inputPanel.clear();
                    } else {
                        SearchInputPanel.this.SEARCH_FIELD.addToDictionary();
                    }
                    SearchInputPanel.this.SEARCH_FIELD.setText("");
                } else if (searchInformation.isBrowseHostSearch()) {
                    SearchInputPanel.this.BROWSE_HOST_FIELD.addToDictionary();
                    SearchInputPanel.this.BROWSE_HOST_FIELD.setText("");
                }
            }
        }
    }

    private class SchemaListener
    implements ActionListener {
        private SchemaListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchSettings.MAX_QUERY_LENGTH.revertToDefault();
            if (SearchInputPanel.this.SCHEMA_BOX.getSelectedSchema() != null) {
                String string = SearchInputPanel.this.SCHEMA_BOX.getSelectedItem();
                if (!SearchInputPanel.this.getInputPanelKeys().contains(string)) {
                    SearchInputPanel.this.createInputPanelForNamedMediaType(SearchInputPanel.this.SCHEMA_BOX.getSelectedMedia());
                }
                SearchInputPanel.this.META_CARDS.show(SearchInputPanel.this.META_PANEL, string);
            } else {
                if (SearchInputPanel.this.SCHEMA_BOX.getSelectedMediaType().equals(MediaType.TYPE_TORRENTS)) {
                    SearchSettings.MAX_QUERY_LENGTH.setValue(100);
                }
                SearchInputPanel.this.META_CARDS.show(SearchInputPanel.this.META_PANEL, SearchInputPanel.DEFAULT_PANEL_KEY);
            }
            if (SearchInputPanel.this.SEARCH_FIELD.getText().length() > SearchSettings.MAX_QUERY_LENGTH.getValue()) {
                try {
                    SearchInputPanel.this.SEARCH_FIELD.setText(SearchInputPanel.this.SEARCH_FIELD.getText(0, SearchSettings.MAX_QUERY_LENGTH.getValue()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            SearchInputPanel.this.WHATSNEW_SEARCH_LABEL.setText(SearchInputPanel.this.SCHEMA_BOX.getSelectedItem());
            SearchInputPanel.this.WHATSNEW_SEARCH_LABEL.setPreferredSize(new Dimension(GUIUtils.width(SearchInputPanel.this.WHATSNEW_SEARCH_LABEL), 20));
            SearchInputPanel.this.SEARCH_TYPE_LABEL.setText(SearchInputPanel.this.SCHEMA_BOX.getSelectedItem());
            SearchInputPanel.this.requestSearchFocus();
        }
    }
}

