/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.search.FilterInputPanel;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInputPanel;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

final class SearchInputManager
implements ThemeObserver {
    private final JPanel COMPONENT_PANEL = new JPanel(new GridBagLayout());
    private final CardLayout MAIN_CARDS = new CardLayout();
    private final JPanel MAIN_PANEL = new JPanel(this.MAIN_CARDS);
    private SearchInputPanel SEARCH;
    private FilterInputPanel FILTER;

    SearchInputManager() {
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        this.SEARCH = new SearchInputPanel(GuiCoreMediator.getNetworkManager(), GuiCoreMediator.getNetworkInstanceUtils());
        this.FILTER = new FilterInputPanel(new ShowSearchListener(), new AutoSearchListener());
        this.MAIN_PANEL.removeAll();
        this.MAIN_PANEL.add((Component)this.SEARCH, "search");
        this.MAIN_PANEL.add((Component)this.FILTER, "filter");
        this.COMPONENT_PANEL.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.COMPONENT_PANEL.add((Component)this.MAIN_PANEL, gridBagConstraints);
    }

    void rebuild() {
        this.updateTheme();
    }

    void addressChanged() {
        this.SEARCH.addressChanged();
    }

    void goToSearch() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchInputManager.this.showSearchCard(false);
            }
        });
    }

    void requestSearchFocus() {
        this.requestSearchFocus(false);
    }

    JComponent getComponent() {
        return this.COMPONENT_PANEL;
    }

    void clearFilters() {
        this.FILTER.clearFilters();
        this.showSearchCard(false);
    }

    void panelReset(ResultPanel resultPanel) {
        this.FILTER.panelReset(resultPanel);
    }

    void panelRemoved(ResultPanel resultPanel) {
        if (this.FILTER.panelRemoved(resultPanel)) {
            this.showSearchCard(false);
        }
    }

    void setFiltersFor(ResultPanel resultPanel) {
        if (UISettings.SEARCH_RESULT_FILTERS.getValue()) {
            boolean bl = this.FILTER.setFiltersFor(resultPanel);
            this.MAIN_CARDS.last(this.MAIN_PANEL);
            if (bl) {
                this.requestFilterFocus();
            }
        }
    }

    private void showSearchCard(boolean bl) {
        this.MAIN_CARDS.first(this.MAIN_PANEL);
        this.requestSearchFocus(bl);
    }

    private void requestSearchFocus(boolean bl) {
        if (bl) {
            this.SEARCH.requestSearchFocusImmediately();
        } else {
            this.SEARCH.requestSearchFocus();
        }
    }

    private void requestFilterFocus() {
        this.FILTER.requestFilterFocus();
    }

    private class AutoSearchListener
    implements KeyListener {
        private AutoSearchListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.forward(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.forward(keyEvent);
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (this.forward(keyEvent)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SearchInputManager.this.showSearchCard(true);
                    }
                });
            }
        }

        private boolean forward(KeyEvent keyEvent) {
            if (SearchInputManager.this.SEARCH.isKeyEventForwardable()) {
                SearchInputManager.this.SEARCH.getForwardingSearchField().processKeyEvent(keyEvent);
                return true;
            }
            return false;
        }
    }

    private class ShowSearchListener
    implements ActionListener {
        private ShowSearchListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SearchInputManager.this.goToSearch();
        }
    }
}

