/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SchemaBox
extends JPanel {
    private static final long serialVersionUID = 4148383858573954999L;
    private static final String SELECT_TYPE = I18n.tr("Select Search Type:");
    private static final String MEDIA = "NAMED_MEDIA_TYPE";
    private static final String SELECTED = "SELECTED_ICON";
    private static final String DESELECTED = "DESELECTED_ICON";
    private final JPanel SCHEMAS = new JPanel();
    private final ButtonGroup GROUP = new ButtonGroup();
    private final ItemListener HIGHLIGHTER = new Highlighter();
    private final MouseListener CLICK_FORWARDER = new Clicker();
    private final Ditherer DITHERER = new Ditherer(20, ThemeFileHandler.FILTER_TITLE_TOP_COLOR.getValue(), ThemeFileHandler.FILTER_TITLE_COLOR.getValue());

    SchemaBox() {
        List<NamedMediaType> list = NamedMediaType.getAllNamedMediaTypes();
        int n = 2;
        int n2 = (int)Math.ceil((double)list.size() / 2.0);
        this.SCHEMAS.setBackground(ThemeFileHandler.SEARCH_GRID_COLOR.getValue());
        this.SCHEMAS.setLayout(new GridLayout(n2, n, 1, 1));
        this.SCHEMAS.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.addSchemas(list);
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel(SELECT_TYPE));
        this.add(jPanel);
        this.setLayout(new BoxLayout(this, 1));
        BoxPanel boxPanel = new BoxPanel(0);
        boxPanel.add(this.SCHEMAS);
        boxPanel.add(Box.createHorizontalStrut(1));
        this.add(boxPanel);
    }

    public void addSelectionListener(ActionListener actionListener) {
        Enumeration<AbstractButton> enumeration = this.GROUP.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            abstractButton.addActionListener(actionListener);
        }
    }

    public Icon getSelectedIcon() {
        NamedMediaType namedMediaType = this.getSelectedMedia();
        if (namedMediaType == null) {
            return null;
        }
        return namedMediaType.getIcon();
    }

    public LimeXMLSchema getSelectedSchema() {
        NamedMediaType namedMediaType = this.getSelectedMedia();
        if (namedMediaType == null) {
            return null;
        }
        return namedMediaType.getSchema();
    }

    public String getSelectedItem() {
        NamedMediaType namedMediaType = this.getSelectedMedia();
        if (namedMediaType == null) {
            return null;
        }
        return namedMediaType.getName();
    }

    public MediaType getSelectedMediaType() {
        NamedMediaType namedMediaType = this.getSelectedMedia();
        if (namedMediaType == null) {
            return null;
        }
        return namedMediaType.getMediaType();
    }

    private void addSchemas(List<? extends NamedMediaType> list) {
        NamedMediaType namedMediaType = NamedMediaType.getFromDescription("*");
        list.remove(namedMediaType);
        this.addMediaType(namedMediaType);
        namedMediaType = NamedMediaType.getFromDescription("audio");
        list.remove(namedMediaType);
        this.addMediaType(namedMediaType, I18n.tr("Search For Audio Files, Including mp3, wav, ogg, and More"));
        namedMediaType = NamedMediaType.getFromDescription("image");
        list.remove(namedMediaType);
        this.addMediaType(namedMediaType, I18n.tr("Search For Image Files, Including jpg, gif, png and More"));
        namedMediaType = NamedMediaType.getFromDescription("video");
        list.remove(namedMediaType);
        this.addMediaType(namedMediaType, I18n.tr("Search For Video Files, Including avi, mpg, wmv, and More"));
        namedMediaType = NamedMediaType.getFromDescription("document");
        list.remove(namedMediaType);
        this.addMediaType(namedMediaType, I18n.tr("Search for Document Files, Including html, txt, pdf, and More"));
        namedMediaType = NamedMediaType.getFromDescription("application");
        list.remove(namedMediaType);
        this.addMediaType(namedMediaType, I18n.tr("Search for Program Files, Including exe, zip, gz, and More"));
        namedMediaType = NamedMediaType.getFromDescription("torrent");
        list.remove(namedMediaType);
        this.addMediaType(namedMediaType, I18n.tr("Search for Torrents!"));
        for (NamedMediaType namedMediaType2 : list) {
            this.addMediaType(namedMediaType2);
        }
    }

    private void addMediaType(NamedMediaType namedMediaType) {
        this.addMediaType(namedMediaType, null);
    }

    private void addMediaType(NamedMediaType namedMediaType, String string) {
        Icon icon = namedMediaType.getIcon();
        Icon icon2 = null;
        Icon icon3 = null;
        JRadioButton jRadioButton = new JRadioButton(namedMediaType.getName());
        jRadioButton.putClientProperty(MEDIA, namedMediaType);
        jRadioButton.putClientProperty(SELECTED, icon);
        if (icon != null) {
            icon2 = ImageManipulator.darken(icon);
            icon3 = ImageManipulator.brighten(icon);
        }
        jRadioButton.putClientProperty(DESELECTED, icon2);
        jRadioButton.setIcon(icon2);
        jRadioButton.setRolloverIcon(icon3);
        jRadioButton.addItemListener(this.HIGHLIGHTER);
        jRadioButton.setBorderPainted(false);
        jRadioButton.setFocusPainted(false);
        jRadioButton.setContentAreaFilled(false);
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton.setOpaque(false);
        jRadioButton.addMouseListener(this.CLICK_FORWARDER);
        jRadioButton.setPreferredSize(new Dimension(100, 22));
        if (string != null) {
            jRadioButton.setToolTipText(string);
        }
        this.GROUP.add(jRadioButton);
        DitherPanel ditherPanel = new DitherPanel(this.DITHERER);
        ditherPanel.setDithering(false);
        ditherPanel.setLayout(new FlowLayout(0, 7, 1));
        ditherPanel.add(jRadioButton);
        ditherPanel.addMouseListener(this.CLICK_FORWARDER);
        ditherPanel.setBackground(UIManager.getColor("TabbedPane.background"));
        this.SCHEMAS.add(ditherPanel);
        if (namedMediaType.getMediaType().equals(MediaType.TYPE_TORRENTS)) {
            jRadioButton.setSelected(true);
        } else {
            jRadioButton.setSelected(false);
        }
    }

    NamedMediaType getSelectedMedia() {
        Enumeration<AbstractButton> enumeration = this.GROUP.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!abstractButton.isSelected()) continue;
            return (NamedMediaType)abstractButton.getClientProperty(MEDIA);
        }
        return null;
    }

    private static void setIfNotNull(JComponent jComponent, String string) {
        Color color = UIManager.getColor(string);
        if (color != null) {
            jComponent.setBackground(color);
        }
    }

    private static class Clicker
    implements MouseListener {
        private Clicker() {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (jComponent instanceof AbstractButton) {
                abstractButton = (AbstractButton)jComponent;
                jComponent = (JComponent)jComponent.getParent();
            } else {
                abstractButton = (AbstractButton)jComponent.getComponent(0);
            }
            if (!abstractButton.isSelected()) {
                SchemaBox.setIfNotNull(jComponent, "TabbedPane.selected");
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AbstractButton abstractButton;
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (jComponent instanceof AbstractButton) {
                abstractButton = (AbstractButton)jComponent;
                jComponent = (JComponent)jComponent.getParent();
            } else {
                abstractButton = (AbstractButton)jComponent.getComponent(0);
            }
            if (!abstractButton.isSelected()) {
                SchemaBox.setIfNotNull(jComponent, "TabbedPane.background");
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (!(jComponent instanceof AbstractButton)) {
                AbstractButton abstractButton = (AbstractButton)jComponent.getComponent(0);
                abstractButton.doClick();
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private static class Highlighter
    implements ItemListener {
        private Highlighter() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            AbstractButton abstractButton = (AbstractButton)itemEvent.getSource();
            DitherPanel ditherPanel = (DitherPanel)abstractButton.getParent();
            if (itemEvent.getStateChange() == 1) {
                abstractButton.setIcon((Icon)abstractButton.getClientProperty(SchemaBox.SELECTED));
                ditherPanel.setDithering(true);
                ditherPanel.setBackground(ThemeFileHandler.FILTER_TITLE_COLOR.getValue());
            } else {
                abstractButton.setIcon((Icon)abstractButton.getClientProperty(SchemaBox.DESELECTED));
                ditherPanel.setDithering(false);
                ditherPanel.setBackground(UIManager.getColor("TabbedPane.background"));
            }
        }
    }
}

