/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

final class QualityRenderer
implements TableCellRenderer,
ThemeObserver {
    private static Border _noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color _unselectedForeground;
    private Color _unselectedBackground;
    private final JLabel STAR_ONE = new JLabel();
    private final JLabel STAR_TWO = new JLabel();
    private final JLabel STAR_THREE = new JLabel();
    private final JLabel STAR_FOUR = new JLabel();
    private final JLabel STAR_FIVE = new JLabel();
    private final JLabel STORE_SONG = new JLabel();
    private final JLabel SAVED_FILE = new JLabel();
    private final JLabel DOWNLOADING_FILE = new JLabel();
    private final JLabel INCOMPLETE_FILE = new JLabel();
    private final JLabel SPAM_FILE = new JLabel();
    private final JLabel SECURE_FILE = new JLabel();
    static final int SPAM_FILE_QUALITY = 1003;
    static final int SAVED_FILE_QUALITY = 1002;
    static final int DOWNLOADING_FILE_QUALITY = 1001;
    static final int INCOMPLETE_FILE_QUALITY = 1000;
    static final int SECURE_QUALITY = 999;
    static final int THIRD_PARTY_RESULT_QUALITY = 5;
    static final int MULTICAST_QUALITY = 4;
    static final int EXCELLENT_QUALITY = 3;
    static final int GOOD_QUALITY = 2;
    static final int FAIR_QUALITY = 1;
    static final int POOR_QUALITY = 0;

    QualityRenderer() {
        this.fix(this.STAR_ONE);
        this.fix(this.STAR_TWO);
        this.fix(this.STAR_THREE);
        this.fix(this.STAR_FOUR);
        this.fix(this.STAR_FIVE);
        this.fix(this.STORE_SONG);
        this.fix(this.SAVED_FILE);
        this.fix(this.DOWNLOADING_FILE);
        this.fix(this.INCOMPLETE_FILE);
        this.fix(this.SPAM_FILE);
        this.fix(this.SECURE_FILE);
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
    }

    private void fix(JLabel jLabel) {
        jLabel.setBorder(_noFocusBorder);
        jLabel.setOpaque(true);
        jLabel.setHorizontalAlignment(0);
    }

    public void updateTheme() {
        this.STAR_ONE.setIcon(GUIMediator.getThemeImage("01_star"));
        this.STAR_TWO.setIcon(GUIMediator.getThemeImage("02_star"));
        this.STAR_THREE.setIcon(GUIMediator.getThemeImage("03_star"));
        this.STAR_FOUR.setIcon(GUIMediator.getThemeImage("04_star"));
        this.STAR_FIVE.setIcon(GUIMediator.getThemeImage("05_star"));
        this.SAVED_FILE.setIcon(GUIMediator.getThemeImage("complete"));
        this.DOWNLOADING_FILE.setIcon(GUIMediator.getThemeImage("downloading"));
        this.INCOMPLETE_FILE.setIcon(GUIMediator.getThemeImage("incomplete"));
        this.SPAM_FILE.setIcon(GUIMediator.getThemeImage("spam_mini"));
        this.SECURE_FILE.setIcon(GUIMediator.getThemeImage("frosthires"));
        this.STORE_SONG.setIcon(GUIMediator.getThemeImage("frosthires"));
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel;
        int n3 = object == null ? 0 : (Integer)object;
        switch (n3) {
            case 999: {
                jLabel = this.SECURE_FILE;
                break;
            }
            case 1003: {
                jLabel = this.SPAM_FILE;
                break;
            }
            case 1002: {
                jLabel = this.SAVED_FILE;
                break;
            }
            case 1001: {
                jLabel = this.DOWNLOADING_FILE;
                break;
            }
            case 1000: {
                jLabel = this.INCOMPLETE_FILE;
                break;
            }
            case 4: {
                jLabel = this.STAR_FIVE;
                break;
            }
            case 5: {
                jLabel = this.STORE_SONG;
                break;
            }
            case 3: {
                jLabel = this.STAR_FOUR;
                break;
            }
            case 2: {
                jLabel = this.STAR_THREE;
                break;
            }
            case 1: {
                jLabel = this.STAR_TWO;
                break;
            }
            default: {
                jLabel = this.STAR_ONE;
            }
        }
        if (bl) {
            jLabel.setForeground(jTable.getSelectionForeground());
            jLabel.setBackground(jTable.getSelectionBackground());
        } else {
            jLabel.setForeground(this._unselectedForeground != null ? this._unselectedForeground : jTable.getForeground());
            jLabel.setBackground(this._unselectedBackground != null ? this._unselectedBackground : jTable.getBackground());
        }
        return jLabel;
    }
}

