/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;

class PropertyFilter
implements TableLineFilter {
    private final TableLineFilter FILTER;

    PropertyFilter(String string, Object object) {
        if (string == null) {
            throw new NullPointerException("null property");
        }
        if (object == null) {
            throw new NullPointerException("null value");
        }
        if (Selector.PropertyType.TYPE.getKey().equals(string)) {
            this.FILTER = new ExtensionFilter(object);
        } else if (Selector.PropertyType.SPEED.getKey().equals(string)) {
            this.FILTER = new SpeedFilter(object);
        } else if (Selector.PropertyType.VENDOR.getKey().equals(string)) {
            this.FILTER = new VendorFilter(object);
        } else {
            throw new IllegalArgumentException("bad property: " + string);
        }
    }

    public boolean allow(TableLine tableLine) {
        return this.FILTER.allow(tableLine);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PropertyFilter)) {
            return false;
        }
        return this.FILTER.equals(((PropertyFilter)object).FILTER);
    }

    private static class VendorFilter
    implements TableLineFilter {
        private final String VENDOR;

        VendorFilter(Object object) {
            this.VENDOR = (String)object;
        }

        public boolean allow(TableLine tableLine) {
            return this.VENDOR.equals(tableLine.getVendor());
        }

        public boolean equals(Object object) {
            if (!(object instanceof VendorFilter)) {
                return false;
            }
            return this.VENDOR.equals(((VendorFilter)object).VENDOR);
        }
    }

    private static class SpeedFilter
    implements TableLineFilter {
        private final ResultSpeed SPEED;

        SpeedFilter(Object object) {
            this.SPEED = (ResultSpeed)object;
        }

        public boolean allow(TableLine tableLine) {
            return this.SPEED.isSameSpeed(tableLine.getSpeed());
        }

        public boolean equals(Object object) {
            if (!(object instanceof SpeedFilter)) {
                return false;
            }
            return this.SPEED.isSameSpeed(((SpeedFilter)object).SPEED);
        }
    }

    private static class ExtensionFilter
    implements TableLineFilter {
        private final String TYPE;

        ExtensionFilter(Object object) {
            this.TYPE = ((IconAndNameHolder)object).getName();
        }

        public boolean allow(TableLine tableLine) {
            return this.TYPE.equalsIgnoreCase(tableLine.getExtension());
        }

        public boolean equals(Object object) {
            if (!(object instanceof ExtensionFilter)) {
                return false;
            }
            return this.TYPE.equals(((ExtensionFilter)object).TYPE);
        }
    }
}

