/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.actions.SearchWhatsNewMediaTypeAction;
import com.limegroup.gnutella.gui.actions.SearchXMLFieldAction;
import com.limegroup.gnutella.gui.search.FilterBox;
import com.limegroup.gnutella.gui.search.FilterPanel;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.MouseObserver;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.limewire.collection.NameValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FilterPopupMenuHandler {
    private FilterPanel filterPanel;

    private FilterPopupMenuHandler(FilterPanel filterPanel) {
        this.filterPanel = filterPanel;
        FilterBox[] filterBoxArray = this.filterPanel.getBoxes();
        for (int i = 0; i < filterBoxArray.length; ++i) {
            filterBoxArray[i].getList().addMouseListener(new DefaultMouseListener(new MouseHandler(filterBoxArray[i])));
        }
    }

    public static void install(FilterPanel filterPanel) {
        new FilterPopupMenuHandler(filterPanel);
    }

    private void createAndShowPopup(FilterBox filterBox, MouseEvent mouseEvent) {
        JList jList = filterBox.getList();
        int n = jList.locationToIndex(mouseEvent.getPoint());
        if (n != -1) {
            jList.setSelectedIndex(n);
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.addData(filterBox, linkedHashMap);
        FilterBox[] filterBoxArray = this.filterPanel.getBoxes();
        for (int i = 0; i < filterBoxArray.length; ++i) {
            this.addData(filterBoxArray[i], linkedHashMap);
        }
        Action[] actionArray = this.createActions(linkedHashMap);
        if (actionArray.length > 0) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (int i = 0; i < actionArray.length; ++i) {
                jPopupMenu.add(new JMenuItem(actionArray[i]));
            }
            jPopupMenu.show(filterBox.getList(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void addData(FilterBox filterBox, Map<? super Selector, Object> map) {
        Object object;
        if (!filterBox.getSelector().isPropertySelector() && (object = filterBox.getSelectedValue()) != null && !MetadataModel.isAll(object)) {
            map.put(filterBox.getSelector(), object);
        }
    }

    private Action[] createActions(Map<? extends Selector, ? extends Object> map) {
        if (map.isEmpty()) {
            return new Action[0];
        }
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        for (Map.Entry<? extends Selector, ? extends Object> entry : map.entrySet()) {
            Selector selector = entry.getKey();
            if (selector.isSchemaSelector()) {
                arrayList.add(new SearchWhatsNewMediaTypeAction((NamedMediaType)entry.getValue()));
                continue;
            }
            if (!selector.isFieldSelector()) continue;
            arrayList.add(new SearchXMLFieldAction(new NameValue<Object>(selector.getTitle(), entry.getValue()), selector.getValue(), entry.getValue().toString(), NamedMediaType.getFromDescription(selector.getSchema())));
        }
        return arrayList.toArray(new Action[0]);
    }

    private class MouseHandler
    implements MouseObserver {
        private FilterBox box;

        public MouseHandler(FilterBox filterBox) {
            this.box = filterBox;
        }

        public void handlePopupMenu(MouseEvent mouseEvent) {
            FilterPopupMenuHandler.this.createAndShowPopup(this.box, mouseEvent);
        }

        public void handleMouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void handleRightMouseClick(MouseEvent mouseEvent) {
        }
    }
}

