/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.search.AllowFilter;
import com.limegroup.gnutella.gui.search.FieldFilter;
import com.limegroup.gnutella.gui.search.FilterBox;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.PropertyFilter;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SchemaFilter;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.SelectorsHandler;
import com.limegroup.gnutella.gui.search.TableLineFilter;
import com.limegroup.gnutella.gui.xml.XMLValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.IOException;
import javax.swing.JList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.xml.sax.SAXException;

class FilterPanel
extends BoxPanel {
    private static int uniqueIdCount = 0;
    private final String ID;
    private final FilterBox BOX_1;
    private final FilterBox BOX_2;
    private final FilterBox BOX_3;
    private final ResultPanel RESULTS;
    private final MetadataModel MODEL;

    public FilterPanel(ResultPanel resultPanel) {
        super(1);
        String string = resultPanel.getMediaType().getMimeType();
        Selector selector = SelectorsHandler.getSelector(string, 0);
        Selector selector2 = SelectorsHandler.getSelector(string, 1);
        Selector selector3 = SelectorsHandler.getSelector(string, 2);
        MetadataModel metadataModel = resultPanel.getMetadataModel();
        this.BOX_1 = new FilterBox(metadataModel, selector);
        this.BOX_2 = new FilterBox(metadataModel, selector2);
        this.BOX_3 = new FilterBox(metadataModel, selector3);
        this.RESULTS = resultPanel;
        this.MODEL = metadataModel;
        new MinimizeManager(new SelectorListener());
        this.add(this.BOX_1.getComponent());
        this.add(this.BOX_2.getComponent());
        this.add(this.BOX_3.getComponent());
        this.setMatchingValues(null);
        this.ID = "" + uniqueIdCount++;
    }

    String getUniqueDescription() {
        return this.ID;
    }

    public FilterBox[] getBoxes() {
        return new FilterBox[]{this.BOX_1, this.BOX_2, this.BOX_3};
    }

    private void setMatchingValues(FilterBox filterBox) {
        SearchInformation searchInformation = this.RESULTS.getSearchInformation();
        if (searchInformation.isKeywordSearch()) {
            LimeXMLDocument limeXMLDocument = null;
            String string = this.RESULTS.getRichQuery();
            if (string != null) {
                try {
                    limeXMLDocument = GuiCoreMediator.getLimeXMLDocumentFactory().createLimeXMLDocument(string);
                }
                catch (SAXException sAXException) {
                }
                catch (SchemaNotFoundException schemaNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (filterBox != null) {
                this.selectMatchingValues(filterBox, limeXMLDocument, searchInformation);
            } else {
                this.selectMatchingValues(this.BOX_1, limeXMLDocument, searchInformation);
                this.selectMatchingValues(this.BOX_2, limeXMLDocument, searchInformation);
                this.selectMatchingValues(this.BOX_3, limeXMLDocument, searchInformation);
            }
        }
    }

    private void selectMatchingValues(FilterBox filterBox, LimeXMLDocument limeXMLDocument, SearchInformation searchInformation) {
        if (!filterBox.getSelector().isFieldSelector()) {
            return;
        }
        String string = searchInformation.getQuery();
        MediaType mediaType = searchInformation.getMediaType();
        String string2 = null;
        if (limeXMLDocument != null) {
            String string3 = filterBox.getSelector().getSchema();
            if (!string3.equals(limeXMLDocument.getSchemaDescription())) {
                return;
            }
            String string4 = filterBox.getSelector().getValue();
            string2 = limeXMLDocument.getValue(string4);
        } else if (mediaType == MediaType.getAnyTypeMediaType()) {
            string2 = string;
        }
        if (string2 != null) {
            filterBox.setRequestedValue(string2);
        }
    }

    private class SelectorListener
    implements ListDataListener,
    ListSelectionListener,
    ChangeListener {
        private boolean triggered = false;

        SelectorListener() {
            FilterPanel.this.BOX_1.addSelectionListener(this, this);
            FilterPanel.this.BOX_2.addSelectionListener(this, this);
            FilterPanel.this.BOX_3.addSelectionListener(this, this);
            FilterPanel.this.BOX_1.setSelectorChangeListener(this);
            FilterPanel.this.BOX_2.setSelectorChangeListener(this);
            FilterPanel.this.BOX_3.setSelectorChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            String string = FilterPanel.this.RESULTS.getMediaType().getMimeType();
            SelectorsHandler.setSelector(string, 0, FilterPanel.this.BOX_1.getSelector());
            SelectorsHandler.setSelector(string, 1, FilterPanel.this.BOX_2.getSelector());
            SelectorsHandler.setSelector(string, 2, FilterPanel.this.BOX_3.getSelector());
            if (changeEvent != null) {
                FilterBox filterBox = (FilterBox)changeEvent.getSource();
                FilterPanel.this.setMatchingValues(filterBox);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl;
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            JList jList = (JList)listSelectionEvent.getSource();
            FilterBox filterBox = null;
            int n = -1;
            if (jList == FilterPanel.this.BOX_1.getList()) {
                filterBox = FilterPanel.this.BOX_1;
                n = 1;
            } else if (jList == FilterPanel.this.BOX_2.getList()) {
                filterBox = FilterPanel.this.BOX_2;
                n = 2;
            } else if (jList == FilterPanel.this.BOX_3.getList()) {
                filterBox = FilterPanel.this.BOX_3;
                n = 3;
            } else {
                throw new IllegalStateException("invalid source: " + jList);
            }
            Selector selector = filterBox.getSelector();
            Object object = filterBox.getSelectedValue();
            boolean bl2 = bl = listSelectionEvent.getFirstIndex() == 0 && listSelectionEvent.getLastIndex() == 0;
            if (bl || this.selectionChanged(selector, object, n)) {
                this.updateBoxes(n, filterBox, true);
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            if (this.triggered) {
                return;
            }
            Object object = listDataEvent.getSource();
            FilterBox filterBox = null;
            int n = -1;
            if (object == FilterPanel.this.BOX_1.getList().getModel()) {
                n = -1;
            } else if (object == FilterPanel.this.BOX_2.getList().getModel()) {
                filterBox = FilterPanel.this.BOX_1;
                n = 0;
            } else if (object == FilterPanel.this.BOX_3.getList().getModel()) {
                filterBox = FilterPanel.this.BOX_2;
                n = 1;
            } else {
                throw new IllegalStateException("invalid source: " + object);
            }
            if (n > -1) {
                this.triggered = true;
                this.updateBoxes(n, filterBox, false);
                this.triggered = false;
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
        }

        private void updateBoxes(int n, FilterBox filterBox, boolean bl) {
            Object object;
            boolean bl2;
            boolean bl3;
            filterBox.updateTitle();
            Object object2 = FilterPanel.this.BOX_1.getSelectedValue();
            boolean bl4 = bl3 = object2 == null || MetadataModel.isAll(object2);
            if (filterBox == FilterPanel.this.BOX_1) {
                if (bl3) {
                    this.allPossible(FilterPanel.this.BOX_2);
                } else {
                    this.changeModel(FilterPanel.this.BOX_1, FilterPanel.this.BOX_2, object2);
                }
                if (bl) {
                    FilterPanel.this.BOX_2.clearSelection();
                }
            }
            boolean bl5 = bl2 = (object = FilterPanel.this.BOX_2.getSelectedValue()) == null || MetadataModel.isAll(object);
            if (filterBox == FilterPanel.this.BOX_2 || filterBox == FilterPanel.this.BOX_1) {
                if (bl2) {
                    if (bl3) {
                        this.allPossible(FilterPanel.this.BOX_3);
                    } else {
                        this.changeModel(FilterPanel.this.BOX_1, FilterPanel.this.BOX_3, object2);
                    }
                } else {
                    this.changeModel(FilterPanel.this.BOX_2, FilterPanel.this.BOX_3, object);
                }
                if (bl) {
                    FilterPanel.this.BOX_3.clearSelection();
                }
            }
        }

        private void allPossible(FilterBox filterBox) {
            filterBox.setModel(FilterPanel.this.MODEL.getListModelMap(filterBox.getSelector()));
        }

        private void changeModel(FilterBox filterBox, FilterBox filterBox2, Object object) {
            filterBox2.setModel(FilterPanel.this.MODEL.getIntersection(filterBox.getModel(), object, FilterPanel.this.MODEL.getListModelMap(filterBox2.getSelector())));
        }

        private boolean selectionChanged(Selector selector, Object object, int n) {
            TableLineFilter tableLineFilter = null;
            if (object == null || MetadataModel.isAll(object)) {
                tableLineFilter = AllowFilter.instance();
            } else {
                switch (selector.getSelectorType()) {
                    case 1: {
                        tableLineFilter = new SchemaFilter((NamedMediaType)object);
                        break;
                    }
                    case 2: {
                        tableLineFilter = new FieldFilter(selector.getSchema(), selector.getValue(), (XMLValue)object);
                        break;
                    }
                    case 3: {
                        tableLineFilter = new PropertyFilter(selector.getValue(), object);
                    }
                }
            }
            return FilterPanel.this.RESULTS.filterChanged(tableLineFilter, n);
        }
    }

    private class MinimizeManager
    implements ChangeListener {
        final ChangeListener SAVER;

        MinimizeManager(ChangeListener changeListener) {
            FilterPanel.this.BOX_1.setStateChangeListener(this);
            FilterPanel.this.BOX_2.setStateChangeListener(this);
            FilterPanel.this.BOX_3.setStateChangeListener(this);
            this.SAVER = changeListener;
            this.stateChanged(null);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            boolean bl = FilterPanel.this.BOX_1.isMinimized();
            boolean bl2 = FilterPanel.this.BOX_2.isMinimized();
            boolean bl3 = FilterPanel.this.BOX_3.isMinimized();
            if (bl && bl2 && bl3) {
                FilterPanel.this.BOX_1.setStateChangeListener(null);
                FilterPanel.this.BOX_1.restore();
                bl = false;
                FilterPanel.this.BOX_1.setStateChangeListener(this);
            }
            if (bl && bl2) {
                FilterPanel.this.BOX_3.setCanMinimize(false);
            } else if (bl && bl3) {
                FilterPanel.this.BOX_2.setCanMinimize(false);
            } else if (bl2 && bl3) {
                FilterPanel.this.BOX_1.setCanMinimize(false);
            } else {
                FilterPanel.this.BOX_1.setCanMinimize(true);
                FilterPanel.this.BOX_2.setCanMinimize(true);
                FilterPanel.this.BOX_3.setCanMinimize(true);
            }
            FilterPanel.this.removeAll();
            FilterPanel.this.add(FilterPanel.this.BOX_1.getComponent());
            FilterPanel.this.add(FilterPanel.this.BOX_2.getComponent());
            FilterPanel.this.add(FilterPanel.this.BOX_3.getComponent());
            FilterPanel.this.invalidate();
            FilterPanel.this.revalidate();
            FilterPanel.this.repaint();
            this.SAVER.stateChanged(changeEvent);
        }
    }
}

