/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.FilterBox;
import com.limegroup.gnutella.gui.search.FilterPanel;
import com.limegroup.gnutella.gui.search.FilterPopupMenuHandler;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.limewire.i18n.I18nMarker;

class FilterInputPanel
extends BoxPanel {
    private final Ditherer DITHERER = new Ditherer(20, ThemeFileHandler.SEARCH_PANEL_BG_1.getValue(), ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
    private final CardLayout FILTER_CARDS = new CardLayout();
    private final JPanel FILTER_PANEL = new JPanel(this.FILTER_CARDS);
    private final Map<ResultPanel, FilterPanel> ACTIVE_FILTERS = new HashMap<ResultPanel, FilterPanel>();
    private JButton backToSearch;

    FilterInputPanel(ActionListener actionListener, KeyListener keyListener) {
        super(1);
        this.add(Box.createVerticalStrut(4));
        this.add(GUIUtils.left(new JLabel(I18n.tr("Filter Results:"))));
        this.add(this.FILTER_PANEL);
        this.add(Box.createVerticalStrut(4));
        this.add(this.createBackToSearchButton(actionListener, keyListener));
    }

    void requestFilterFocus() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilterInputPanel.this.backToSearch.requestFocus();
            }
        });
    }

    void clearFilters() {
        Iterator<FilterPanel> iterator = this.ACTIVE_FILTERS.values().iterator();
        while (iterator.hasNext()) {
            this.FILTER_PANEL.remove(iterator.next());
            iterator.remove();
        }
        FilterBox.clearRenderer();
    }

    void panelReset(ResultPanel resultPanel) {
        FilterPanel filterPanel = this.ACTIVE_FILTERS.get(resultPanel);
        if (filterPanel != null) {
            this.FILTER_PANEL.remove(filterPanel);
            this.ACTIVE_FILTERS.remove(resultPanel);
            this.setFiltersFor(resultPanel);
        }
    }

    boolean panelRemoved(ResultPanel resultPanel) {
        FilterPanel filterPanel = this.ACTIVE_FILTERS.get(resultPanel);
        if (filterPanel != null) {
            this.FILTER_PANEL.remove(filterPanel);
            this.ACTIVE_FILTERS.remove(resultPanel);
        }
        FilterBox.clearRenderer();
        return this.ACTIVE_FILTERS.isEmpty();
    }

    boolean setFiltersFor(ResultPanel resultPanel) {
        boolean bl = false;
        FilterPanel filterPanel = this.ACTIVE_FILTERS.get(resultPanel);
        if (filterPanel == null) {
            bl = true;
            filterPanel = new FilterPanel(resultPanel);
            FilterPopupMenuHandler.install(filterPanel);
            this.FILTER_PANEL.add((Component)filterPanel, filterPanel.getUniqueDescription());
            this.ACTIVE_FILTERS.put(resultPanel, filterPanel);
        }
        this.FILTER_CARDS.show(this.FILTER_PANEL, filterPanel.getUniqueDescription());
        return bl;
    }

    private JPanel createBackToSearchButton(ActionListener actionListener, KeyListener keyListener) {
        IconButton iconButton = new IconButton(I18n.tr("Back To Search"), I18nMarker.marktr("Back To Search"));
        iconButton.addActionListener(actionListener);
        iconButton.addKeyListener(keyListener);
        iconButton.setRequestFocusEnabled(true);
        DitherPanel ditherPanel = new DitherPanel(this.DITHERER);
        ditherPanel.setLayout(new BoxLayout(ditherPanel, 1));
        ditherPanel.add(Box.createVerticalStrut(5));
        ditherPanel.add(GUIUtils.center(iconButton));
        ditherPanel.add(Box.createVerticalStrut(5));
        ditherPanel.setBackground(ThemeFileHandler.SEARCH_PANEL_BG_2.getValue());
        GUIUtils.setOpaque(false, ditherPanel);
        if (!ThemeSettings.isNativeTheme()) {
            ditherPanel.setOpaque(true);
        }
        ditherPanel.setBorder(BorderFactory.createLineBorder(ThemeFileHandler.SEARCH_GRID_COLOR.getValue()));
        this.backToSearch = iconButton;
        return ditherPanel;
    }
}

