/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.search.DitherPanel;
import com.limegroup.gnutella.gui.search.Ditherer;
import com.limegroup.gnutella.gui.search.ListModelMap;
import com.limegroup.gnutella.gui.search.MetadataModel;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.SelectorMenu;
import com.limegroup.gnutella.gui.tables.CircularIcon;
import com.limegroup.gnutella.gui.tables.IconAndNameHolder;
import com.limegroup.gnutella.gui.tables.SortArrowIcon;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.xml.XMLValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.limewire.setting.BooleanSetting;
import org.limewire.util.StringUtils;

class FilterBox
extends JPanel {
    private static final ListCellRenderer RENDERER = new Renderer();
    private static final ListSelectionListener MOVER = new Mover();
    private static final BooleanSetting STRIPE_ROWS = ResultPanel.SEARCH_SETTINGS.ROWSTRIPE;
    private static final String OPTIONS = I18n.tr("Options");
    private static final String OPTION = I18n.tr("Option");
    private static final String SELECTED = "SELECTION";
    private static final String MATCH = "MATCH";
    private static final String MATCH_IDX = "MATCH_IDX";
    private final Ditherer DITHERER = new Ditherer(10, ThemeFileHandler.FILTER_TITLE_TOP_COLOR.getValue(), ThemeFileHandler.FILTER_TITLE_COLOR.getValue());
    protected final JLabel TITLE;
    protected final JPanel TITLE_PANEL;
    protected final JList LIST;
    protected final JPanel LIST_PANEL;
    protected final ListModelDelegator DELEGATOR;
    protected final JLabel CONTROLS;
    protected final MetadataModel MODEL;
    protected final ChangeEvent EVENT = new ChangeEvent(this);
    protected Selector _selector;
    protected ChangeListener _selectorChangeListener;
    protected ChangeListener _stateChangeListener;
    private boolean _minimized = false;
    private boolean _canMinimize = true;
    private boolean _mouseClicked = false;
    private String _requestedValue;
    private String[] _requestedValues;

    FilterBox(MetadataModel metadataModel, Selector selector) {
        this.setLayout(new BorderLayout());
        if (metadataModel == null) {
            throw new NullPointerException("no model");
        }
        if (selector == null) {
            throw new NullPointerException("no selector");
        }
        this.CONTROLS = new JLabel();
        this.TITLE = new JLabel();
        this.TITLE.setFont(UIManager.getFont("Table.font.bold"));
        this.TITLE_PANEL = this.createTitlePanel(this.TITLE, this.CONTROLS);
        this.LIST = new JList();
        this.LIST.setTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLER);
        this.DELEGATOR = new ListModelDelegator();
        JScrollPane jScrollPane = new JScrollPane(this.LIST);
        this.LIST_PANEL = this.addToPanel(jScrollPane, false);
        this.MODEL = metadataModel;
        this.add((Component)this.TITLE_PANEL, "North");
        this.add((Component)this.LIST_PANEL, "Center");
        this.LIST.setBackground(ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue());
        this.LIST.setCellRenderer(RENDERER);
        this.LIST.addListSelectionListener(MOVER);
        this.LIST.setModel(this.DELEGATOR);
        this.LIST.setSelectionMode(0);
        this.LIST.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }

            public void mousePressed(MouseEvent mouseEvent) {
                FilterBox.this._mouseClicked = true;
                FilterBox.this.LIST.removeMouseListener(this);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }
        });
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createLoweredBevelBorder()));
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.setSelector(selector);
    }

    JList getList() {
        return this.LIST;
    }

    JComponent getComponent() {
        if (this._minimized) {
            return this.TITLE_PANEL;
        }
        this.removeAll();
        this.add((Component)this.TITLE_PANEL, "North");
        this.add((Component)this.LIST_PANEL, "Center");
        return this;
    }

    void minimize() {
        this._minimized = true;
        this._selector.setMinimized(true);
        this.TITLE.setFont(UIManager.getFont("Table.font"));
        this.TITLE_PANEL.setBorder(this.getBorder());
        this.invalidate();
        this.CONTROLS.setIcon(SortArrowIcon.getAscendingIcon());
        this.updateTitle();
        this.revalidate();
        if (this._stateChangeListener != null) {
            this._stateChangeListener.stateChanged(this.EVENT);
        }
    }

    void restore() {
        this._minimized = false;
        this._selector.setMinimized(false);
        this.TITLE.setFont(UIManager.getFont("Table.font.bold"));
        this.TITLE_PANEL.setBorder(null);
        this.updateTitle();
        this.CONTROLS.setIcon(SortArrowIcon.getDescendingIcon());
        this.revalidate();
        if (this._stateChangeListener != null) {
            this._stateChangeListener.stateChanged(this.EVENT);
        }
    }

    void setCanMinimize(boolean bl) {
        if (this._minimized) {
            return;
        }
        if (bl) {
            this.CONTROLS.setIcon(SortArrowIcon.getDescendingIcon());
        } else {
            this.CONTROLS.setIcon(null);
        }
        this._canMinimize = bl;
    }

    boolean isMinimized() {
        return this._minimized;
    }

    MetadataModel getMetadataModel() {
        return this.MODEL;
    }

    Selector getSelector() {
        return this._selector;
    }

    void setSelectorChangeListener(ChangeListener changeListener) {
        this._selectorChangeListener = changeListener;
    }

    void setStateChangeListener(ChangeListener changeListener) {
        this._stateChangeListener = changeListener;
    }

    void setSelector(Selector selector) {
        if (selector == null) {
            throw new NullPointerException("no selector");
        }
        this.LIST.putClientProperty(MATCH, null);
        this.LIST.putClientProperty(MATCH_IDX, null);
        this.LIST.putClientProperty(SELECTED, null);
        ListModelMap listModelMap = this._selector == null ? null : this.MODEL.getListModelMap(this._selector);
        this._selector = selector;
        ListModelMap listModelMap2 = this.MODEL.getListModelMap(selector);
        this.setModel(listModelMap2);
        this.DELEGATOR.changeListener(listModelMap, listModelMap2);
        if (selector.isMinimized()) {
            this.minimize();
        }
        if (this._selectorChangeListener != null) {
            this._selectorChangeListener.stateChanged(this.EVENT);
        }
        this.updateTitle();
    }

    void updateTitle() {
        Object object = this.getSelectedValue();
        String string = FilterBox.getTitle(this._selector);
        String string2 = this.TITLE.getText();
        if (!this._minimized) {
            this.TITLE.setText(string);
        } else {
            int n;
            String string3 = object == null || MetadataModel.isAll(object) ? ((n = this.DELEGATOR.getSize() - 1) == 1 ? n + " " + OPTION : n + " " + OPTIONS) : object.toString();
            this.TITLE.setText(string + " (" + string3 + ")");
        }
        if (!string2.equals(this.TITLE.getText())) {
            this.TITLE.setPreferredSize(new Dimension(GUIUtils.width(this.TITLE), 13));
        }
    }

    Object getSelectedValue() {
        int n = this.LIST.getSelectedIndex();
        if (n < 0 || n >= this.DELEGATOR.getSize()) {
            return null;
        }
        return this.LIST.getSelectedValue();
    }

    void setRequestedValue(String string) {
        this._mouseClicked = false;
        this._requestedValue = string.trim().toLowerCase();
        this._requestedValues = StringUtils.split(this._requestedValue, ' ');
        this.selectValueFromScore();
    }

    void clearSelection() {
        this.LIST.putClientProperty(SELECTED, null);
        this.LIST.clearSelection();
    }

    void setModel(ListModelMap listModelMap) {
        Object object = this.LIST.getClientProperty(SELECTED);
        this.DELEGATOR.setDelegate(listModelMap);
        if (object != null) {
            int n = this.indexOf(object);
            if (n != -1) {
                this.setSelectedIndex(n, true);
                this.selectMatchingValue(false);
            } else {
                this.LIST.clearSelection();
                this.selectMatchingValue(true);
            }
        } else {
            this.LIST.clearSelection();
            this.selectMatchingValue(true);
        }
        this.updateTitle();
    }

    ListModelMap getModel() {
        return this.DELEGATOR.getDelegate();
    }

    void addSelectionListener(ListDataListener listDataListener, ListSelectionListener listSelectionListener) {
        this.LIST.addListSelectionListener(listSelectionListener);
        this.DELEGATOR.addListDataListener(listDataListener);
    }

    protected JPanel createTitlePanel(JLabel jLabel, JLabel jLabel2) {
        jLabel.setHorizontalAlignment(0);
        JLabel jLabel3 = new JLabel(CircularIcon.instance());
        jLabel3.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                JComponent jComponent = (JComponent)mouseEvent.getSource();
                SelectorMenu selectorMenu = new SelectorMenu(FilterBox.this);
                selectorMenu.getComponent().show(jComponent, point.x + 1, point.y - 6);
            }
        });
        jLabel2.setIcon(SortArrowIcon.getDescendingIcon());
        jLabel2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (FilterBox.this._minimized) {
                    FilterBox.this.restore();
                } else if (FilterBox.this._canMinimize) {
                    FilterBox.this.minimize();
                }
            }
        });
        DitherPanel ditherPanel = new DitherPanel(this.DITHERER);
        ditherPanel.setBackground(ThemeFileHandler.FILTER_TITLE_COLOR.getValue());
        ditherPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        ditherPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 1, 0, 1);
        ditherPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        ditherPanel.add((Component)jLabel2, gridBagConstraints);
        ditherPanel.setMaximumSize(new Dimension(9999999, CircularIcon.instance().getIconHeight() + 4));
        return ditherPanel;
    }

    protected JPanel addToPanel(JComponent jComponent, boolean bl) {
        JPanel jPanel = new JPanel(new GridLayout());
        jPanel.add(jComponent);
        jPanel.setMaximumSize(jComponent.getMaximumSize());
        jPanel.setPreferredSize(jComponent.getPreferredSize());
        return jPanel;
    }

    private void selectValueFromScore() {
        if (this._requestedValue == null) {
            return;
        }
        ListModelMap listModelMap = this.DELEGATOR.getDelegate();
        int n = 0;
        int n2 = -1;
        Object var4_4 = null;
        int n3 = 1;
        for (Object k : listModelMap) {
            block10: {
                String string;
                block9: {
                    block8: {
                        if (!(k instanceof XMLValue)) break block8;
                        string = k.toString();
                        break block9;
                    }
                    if (!(k instanceof String)) break block10;
                    string = (String)k;
                }
                int n4 = this.score(string, n);
                if (n4 > n) {
                    n = n4;
                    n2 = n3;
                    var4_4 = k;
                }
                if (n == 100) {
                    this._mouseClicked = true;
                    break;
                }
            }
            ++n3;
        }
        if (n2 != -1) {
            this.LIST.putClientProperty(MATCH, var4_4);
            this.LIST.putClientProperty(MATCH_IDX, new Integer(n2));
            this.LIST.ensureIndexIsVisible(n2);
        }
    }

    private void selectMatchingValue(boolean bl) {
        Object object = this.LIST.getClientProperty(MATCH);
        if (object != null) {
            int n = this.indexOf(object);
            if (n != -1) {
                this.LIST.putClientProperty(MATCH_IDX, new Integer(n));
                if (bl) {
                    this.LIST.ensureIndexIsVisible(n);
                }
            } else {
                this.LIST.putClientProperty(MATCH_IDX, null);
            }
        }
    }

    private int indexOf(Object object) {
        ListModelMap listModelMap = this.DELEGATOR.getDelegate();
        if (listModelMap != null) {
            return listModelMap.indexOf(object);
        }
        return -1;
    }

    private void setSelectedIndex(int n, boolean bl) {
        this.LIST.setSelectedIndex(n);
        if (bl) {
            this.LIST.ensureIndexIsVisible(n);
        }
        this.LIST.repaint();
    }

    private int score(String string, int n) {
        if (this._requestedValue.equals((string = string.toLowerCase()).trim())) {
            return 100;
        }
        if (n > 99) {
            return 0;
        }
        if (string.indexOf(this._requestedValue) > -1) {
            return 99;
        }
        if (n > 98) {
            return 0;
        }
        if (this._requestedValues.length == 1) {
            return 0;
        }
        if (this._requestedValues.length == n) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < this._requestedValues.length; ++i) {
            if (string.indexOf(this._requestedValues[i]) <= -1) continue;
            ++n2;
        }
        return n2;
    }

    private static String getTitle(Selector selector) {
        return selector.getTitle();
    }

    public static void clearRenderer() {
        Container container = ((Component)((Object)RENDERER)).getParent();
        if (container != null) {
            container.remove((Component)((Object)RENDERER));
        }
    }

    private static class Mover
    implements ListSelectionListener {
        private Mover() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            JList jList = (JList)listSelectionEvent.getSource();
            int n = jList.getSelectedIndex();
            if (n != -1) {
                jList.ensureIndexIsVisible(n);
                jList.putClientProperty(FilterBox.SELECTED, jList.getSelectedValue());
            }
        }
    }

    private static class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Integer n2 = (Integer)jList.getClientProperty(FilterBox.MATCH_IDX);
            boolean bl3 = n2 != null && n == n2;
            this.setComponentOrientation(jList.getComponentOrientation());
            if (bl) {
                if (bl3) {
                    this.setFont(UIManager.getFont("Table.font.bold"));
                } else {
                    this.setFont(UIManager.getFont("Table.font"));
                }
                this.setOpaque(true);
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                if (bl3) {
                    this.setFont(UIManager.getFont("Table.font.bold"));
                    this.setForeground(jList.getForeground());
                } else {
                    this.setFont(UIManager.getFont("Table.font"));
                    this.setForeground(jList.getForeground());
                }
                if (n % 2 == 0 && STRIPE_ROWS.getValue()) {
                    this.setOpaque(true);
                    this.setBackground(ThemeFileHandler.TABLE_ALTERNATE_COLOR.getValue());
                } else {
                    this.setOpaque(false);
                }
            }
            if (object instanceof IconAndNameHolder) {
                IconAndNameHolder iconAndNameHolder = (IconAndNameHolder)object;
                this.setIcon(iconAndNameHolder.getIcon());
                this.setText(iconAndNameHolder.getName());
            } else {
                this.setIcon(null);
                this.setText(object == null ? "" : object.toString());
            }
            this.setEnabled(jList.isEnabled());
            this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
            return this;
        }
    }

    private class ListModelDelegator
    extends AbstractListModel
    implements ListDataListener {
        private ListModelMap _delegate = null;

        private ListModelDelegator() {
        }

        void setDelegate(ListModelMap listModelMap) {
            if (this._delegate == listModelMap) {
                return;
            }
            this._delegate = listModelMap;
            this.fireContentsChanged(this, 0, this.getSize());
        }

        void changeListener(ListModelMap listModelMap, ListModelMap listModelMap2) {
            if (listModelMap != null) {
                listModelMap.removeListDataListener(this);
            }
            listModelMap2.addListDataListener(this);
        }

        ListModelMap getDelegate() {
            return this._delegate;
        }

        public int getSize() {
            if (this._delegate != null) {
                return this._delegate.getSize();
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (this._delegate != null) {
                return this._delegate.getElementAt(n);
            }
            return null;
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            listDataEvent = new ListDataEvent(this, listDataEvent.getType(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ListDataListener.class) continue;
                ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            listDataEvent = new ListDataEvent(this, listDataEvent.getType(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
            Object[] objectArray = this.listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != ListDataListener.class) continue;
                ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            int n;
            listDataEvent = new ListDataEvent(this, listDataEvent.getType(), listDataEvent.getIndex0(), listDataEvent.getIndex1());
            Object[] objectArray = this.listenerList.getListenerList();
            for (n = objectArray.length - 2; n >= 0; n -= 2) {
                if (objectArray[n] != ListDataListener.class) continue;
                ((ListDataListener)objectArray[n + 1]).contentsChanged(listDataEvent);
            }
            if (!FilterBox.this._mouseClicked && FilterBox.this._requestedValue != null) {
                FilterBox.this.selectValueFromScore();
            } else {
                n = FilterBox.this.LIST.getClientProperty(FilterBox.MATCH) != null ? 1 : 0;
                Object object = FilterBox.this.LIST.getClientProperty(FilterBox.SELECTED);
                if (object != null) {
                    FilterBox.this.setSelectedIndex(FilterBox.this.indexOf(object), true);
                    if (n != 0) {
                        FilterBox.this.selectMatchingValue(false);
                    }
                } else if (n != 0) {
                    FilterBox.this.selectMatchingValue(true);
                }
            }
            FilterBox.this.updateTitle();
        }
    }
}

