/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

public class ShutdownPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Shutdown Behavior");
    public static final String LABEL = I18n.tr("You can choose the default shutdown behavior.");
    private JRadioButton shutdownImmediately;
    private JRadioButton shutdownAfterTransfers;
    private JRadioButton minimizeToTray;

    public ShutdownPaneItem() {
        super(TITLE, LABEL);
        BoxPanel boxPanel = new BoxPanel();
        String string = I18nMarker.marktr("Shutdown Immediately");
        String string2 = I18nMarker.marktr("Shutdown after Transfers");
        String string3 = I18nMarker.marktr("Minimize to System Tray");
        this.shutdownImmediately = new JRadioButton(I18n.tr(string));
        this.shutdownAfterTransfers = new JRadioButton(I18n.tr(string2));
        this.minimizeToTray = new JRadioButton(I18n.tr(string3));
        ButtonGroup buttonGroup = new ButtonGroup();
        boxPanel.add(this.shutdownImmediately);
        boxPanel.add(this.shutdownAfterTransfers);
        buttonGroup.add(this.shutdownImmediately);
        buttonGroup.add(this.shutdownAfterTransfers);
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            boxPanel.add(this.minimizeToTray);
            buttonGroup.add(this.minimizeToTray);
        }
        BoxPanel boxPanel2 = new BoxPanel(0);
        boxPanel2.add(boxPanel);
        boxPanel2.add(Box.createHorizontalGlue());
        this.add(boxPanel2);
    }

    public boolean applyOptions() throws IOException {
        if (this.minimizeToTray.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(true);
            ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.setValue(false);
        } else if (this.shutdownAfterTransfers.isSelected()) {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(false);
            ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.setValue(true);
        } else {
            ApplicationSettings.MINIMIZE_TO_TRAY.setValue(false);
            ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.setValue(false);
        }
        return false;
    }

    public void initOptions() {
        if (ApplicationSettings.MINIMIZE_TO_TRAY.getValue()) {
            if (OSUtils.supportsTray() && !ResourceManager.instance().isTrayIconAvailable()) {
                this.shutdownAfterTransfers.setSelected(true);
            } else {
                this.minimizeToTray.setSelected(true);
            }
        } else if (ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue()) {
            this.shutdownAfterTransfers.setSelected(true);
        } else {
            this.shutdownImmediately.setSelected(true);
        }
    }

    public boolean isDirty() {
        boolean bl = ApplicationSettings.MINIMIZE_TO_TRAY.getValue() && !ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue();
        boolean bl2 = bl && ResourceManager.instance().isTrayIconAvailable();
        boolean bl3 = !ApplicationSettings.MINIMIZE_TO_TRAY.getValue() && ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue();
        boolean bl4 = bl3 || bl && !ResourceManager.instance().isTrayLibraryLoaded();
        boolean bl5 = !ApplicationSettings.MINIMIZE_TO_TRAY.getValue() && !ApplicationSettings.SHUTDOWN_AFTER_TRANSFERS.getValue();
        return this.minimizeToTray.isSelected() != bl2 || this.shutdownAfterTransfers.isSelected() != bl4 || this.shutdownImmediately.isSelected() != bl5;
    }
}

