/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SearchSettings;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;

public final class SearchQualityPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Search Result Quality");
    public static final String LABEL = I18n.tr("You can select the \"quality\" of search results to display. Four star results indicate that the host returning the result is not firewalled and has free upload slots.");
    private final JRadioButton FOUR_STAR_BUTTON = new JRadioButton();
    private final JRadioButton THREE_AND_FOUR_STAR_BUTTON = new JRadioButton();
    private final JRadioButton TWO_THREE_AND_FOUR_STAR_BUTTON = new JRadioButton();
    private final JRadioButton ALL_RESULTS_BUTTON = new JRadioButton();

    public SearchQualityPaneItem() {
        super(TITLE, LABEL);
        String string = I18nMarker.marktr("Show Only Four Star Results");
        String string2 = I18nMarker.marktr("Show Only Three and Four Star Results");
        String string3 = I18nMarker.marktr("Show Only Two, Three, and Four Star Results");
        String string4 = I18nMarker.marktr("Show All Qualities");
        String string5 = I18n.tr(string);
        String string6 = I18n.tr(string2);
        String string7 = I18n.tr(string3);
        String string8 = I18n.tr(string4);
        this.FOUR_STAR_BUTTON.setText(string5);
        this.THREE_AND_FOUR_STAR_BUTTON.setText(string6);
        this.TWO_THREE_AND_FOUR_STAR_BUTTON.setText(string7);
        this.ALL_RESULTS_BUTTON.setText(string8);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.FOUR_STAR_BUTTON);
        buttonGroup.add(this.THREE_AND_FOUR_STAR_BUTTON);
        buttonGroup.add(this.TWO_THREE_AND_FOUR_STAR_BUTTON);
        buttonGroup.add(this.ALL_RESULTS_BUTTON);
        BoxPanel boxPanel = new BoxPanel();
        boxPanel.add(Box.createHorizontalGlue());
        boxPanel.add(this.FOUR_STAR_BUTTON);
        boxPanel.add(this.THREE_AND_FOUR_STAR_BUTTON);
        boxPanel.add(this.TWO_THREE_AND_FOUR_STAR_BUTTON);
        boxPanel.add(this.ALL_RESULTS_BUTTON);
        this.add(boxPanel);
    }

    public void initOptions() {
        int n = SearchSettings.MINIMUM_SEARCH_QUALITY.getValue();
        switch (n) {
            case 3: {
                this.FOUR_STAR_BUTTON.setSelected(true);
                break;
            }
            case 2: {
                this.THREE_AND_FOUR_STAR_BUTTON.setSelected(true);
                break;
            }
            case 1: {
                this.TWO_THREE_AND_FOUR_STAR_BUTTON.setSelected(true);
                break;
            }
            default: {
                this.ALL_RESULTS_BUTTON.setSelected(true);
            }
        }
    }

    public boolean applyOptions() throws IOException {
        int n = 3;
        n = this.FOUR_STAR_BUTTON.isSelected() ? 3 : (this.THREE_AND_FOUR_STAR_BUTTON.isSelected() ? 2 : (this.TWO_THREE_AND_FOUR_STAR_BUTTON.isSelected() ? 1 : 0));
        SearchSettings.MINIMUM_SEARCH_QUALITY.setValue(n);
        return false;
    }

    public boolean isDirty() {
        switch (SearchSettings.MINIMUM_SEARCH_QUALITY.getValue()) {
            case 3: {
                return !this.FOUR_STAR_BUTTON.isSelected();
            }
            case 2: {
                return !this.THREE_AND_FOUR_STAR_BUTTON.isSelected();
            }
            case 1: {
                return !this.TWO_THREE_AND_FOUR_STAR_BUTTON.isSelected();
            }
            case 0: {
                return !this.ALL_RESULTS_BUTTON.isSelected();
            }
        }
        return true;
    }
}

