/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class NetworkInterfacePaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Network Interface");
    public static final String LABEL = I18n.tr("You can tell FrostWire to bind outgoing connections to an IP address from a specific network interface. Listening sockets will still listen on all available interfaces. This is useful on multi-homed hosts. If you later disable this interface, FrostWire will revert to binding to an arbitrary address.");
    private static final String ADDRESS = "limewire.networkinterfacepane.address";
    private final ButtonGroup GROUP = new ButtonGroup();
    private final JCheckBox CUSTOM;
    private List<JRadioButton> activeButtons = new ArrayList<JRadioButton>();

    public NetworkInterfacePaneItem() {
        super(TITLE, LABEL);
        this.CUSTOM = new JCheckBox(I18n.tr("Use a specific network interface."));
        this.CUSTOM.setSelected(ConnectionSettings.CUSTOM_NETWORK_INTERFACE.getValue());
        this.CUSTOM.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                NetworkInterfacePaneItem.this.updateButtons(NetworkInterfacePaneItem.this.CUSTOM.isSelected());
            }
        });
        this.add(this.CUSTOM);
        try {
            Object object;
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                JLabel jLabel = new JLabel(((NetworkInterface)object).getDisplayName());
                gridBagConstraints.insets = new Insets(5, 0, 2, 0);
                jPanel.add((Component)jLabel, gridBagConstraints);
                Enumeration<InetAddress> enumeration2 = ((NetworkInterface)object).getInetAddresses();
                gridBagConstraints.insets = new Insets(0, 6, 0, 0);
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    JRadioButton jRadioButton = new JRadioButton(inetAddress.getHostAddress());
                    this.GROUP.add(jRadioButton);
                    if (inetAddress.isAnyLocalAddress() || inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress()) {
                        jRadioButton.setEnabled(false);
                    } else {
                        this.activeButtons.add(jRadioButton);
                    }
                    if (ConnectionSettings.CUSTOM_INETADRESS.getValue().equals(inetAddress.getHostAddress())) {
                        jRadioButton.setSelected(true);
                    }
                    jRadioButton.putClientProperty(ADDRESS, inetAddress);
                    jPanel.add((Component)jRadioButton, gridBagConstraints);
                }
            }
            this.initializeSelection();
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.gridheight = 0;
            jPanel.add(Box.createGlue(), gridBagConstraints);
            object = new JScrollPane(jPanel);
            ((JComponent)object).setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)object);
            this.updateButtons(this.CUSTOM.isSelected());
        }
        catch (SocketException socketException) {
            this.CUSTOM.setSelected(false);
            BoxPanel boxPanel = new BoxPanel(0);
            boxPanel.add(new JLabel(I18n.tr("FrostWire was unable to determine which network interfaces are available on this machine. Outgoing connections will bind to any arbitrary interface.")));
            boxPanel.add(Box.createHorizontalGlue());
            BoxPanel boxPanel2 = new BoxPanel();
            boxPanel2.add(boxPanel);
            boxPanel2.add(Box.createVerticalGlue());
            this.add(boxPanel2);
        }
    }

    protected void updateButtons(boolean bl) {
        for (JRadioButton jRadioButton : this.activeButtons) {
            jRadioButton.setEnabled(bl);
        }
    }

    private void initializeSelection() {
        AbstractButton abstractButton;
        Enumeration<AbstractButton> enumeration = this.GROUP.getElements();
        while (enumeration.hasMoreElements()) {
            abstractButton = enumeration.nextElement();
            if (!abstractButton.isSelected()) continue;
            return;
        }
        enumeration = this.GROUP.getElements();
        while (enumeration.hasMoreElements()) {
            abstractButton = enumeration.nextElement();
            if (!abstractButton.isEnabled()) continue;
            abstractButton.setSelected(true);
            return;
        }
    }

    public boolean applyOptions() throws IOException {
        ConnectionSettings.CUSTOM_NETWORK_INTERFACE.setValue(this.CUSTOM.isSelected());
        Enumeration<AbstractButton> enumeration = this.GROUP.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (!abstractButton.isSelected()) continue;
            InetAddress inetAddress = (InetAddress)abstractButton.getClientProperty(ADDRESS);
            ConnectionSettings.CUSTOM_INETADRESS.setValue(inetAddress.getHostAddress());
        }
        return false;
    }

    public boolean isDirty() {
        if (!ConnectionSettings.CUSTOM_NETWORK_INTERFACE.getValue()) {
            return this.CUSTOM.isSelected();
        }
        String string = ConnectionSettings.CUSTOM_INETADRESS.getValue();
        Enumeration<AbstractButton> enumeration = this.GROUP.getElements();
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress;
            AbstractButton abstractButton = enumeration.nextElement();
            if (!abstractButton.isSelected() || !(inetAddress = (InetAddress)abstractButton.getClientProperty(ADDRESS)).getHostAddress().equals(string)) continue;
            return false;
        }
        return true;
    }

    public void initOptions() {
    }
}

