/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.panes.MediaTypeDownloadDirDataLine;
import com.limegroup.gnutella.gui.options.panes.MediaTypeDownloadDirModel;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MediaTypeDownloadDirMediator
extends AbstractTableMediator<MediaTypeDownloadDirModel, MediaTypeDownloadDirDataLine, NamedMediaType> {
    private final JTextField saveField;
    private BrowseDirectoryAction browseAction;
    private ResetDirectoryAction resetAction;
    private static TableSettings cachedSettings = null;

    public MediaTypeDownloadDirMediator(JTextField jTextField) {
        super("MEDIA_TYPE_DOWNLOAD_DIR_TABLE");
        this.saveField = jTextField;
        this.saveField.getDocument().addDocumentListener(new DocumentHandler());
    }

    public boolean isDirty() {
        for (int i = 0; i < ((MediaTypeDownloadDirModel)this.DATA_MODEL).getRowCount(); ++i) {
            if (!((MediaTypeDownloadDirDataLine)((MediaTypeDownloadDirModel)this.DATA_MODEL).get(i)).isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void buildSettings() {
        if (cachedSettings == null) {
            super.buildSettings();
            cachedSettings = this.SETTINGS;
        }
        this.SETTINGS = cachedSettings;
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(0);
        this.DATA_MODEL = new MediaTypeDownloadDirModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.TABLE.setSelectionMode(0);
        this.browseAction = new BrowseDirectoryAction();
        this.resetAction = new ResetDirectoryAction();
    }

    public boolean applyOptions(Set<? super File> set) {
        for (int i = 0; i < ((MediaTypeDownloadDirModel)this.DATA_MODEL).getRowCount(); ++i) {
            MediaTypeDownloadDirDataLine mediaTypeDownloadDirDataLine = (MediaTypeDownloadDirDataLine)((MediaTypeDownloadDirModel)this.DATA_MODEL).get(i);
            mediaTypeDownloadDirDataLine.saveDirectory(set);
        }
        return false;
    }

    void addSaveDirs(Set<File> set) {
        for (int i = 0; i < ((MediaTypeDownloadDirModel)this.DATA_MODEL).getRowCount(); ++i) {
            String string = ((MediaTypeDownloadDirDataLine)((MediaTypeDownloadDirModel)this.DATA_MODEL).get(i)).getDirectory();
            if (string == null) continue;
            set.add(new File(string));
        }
    }

    public void initOptions() {
        ((MediaTypeDownloadDirModel)this.DATA_MODEL).clear();
        for (NamedMediaType namedMediaType : NamedMediaType.getAllNamedMediaTypes()) {
            if (namedMediaType.getMediaType().getMimeType().equals("*")) continue;
            ((MediaTypeDownloadDirModel)this.DATA_MODEL).add(namedMediaType);
        }
        ((MediaTypeDownloadDirModel)this.DATA_MODEL).sort(0);
        ((MediaTypeDownloadDirModel)this.DATA_MODEL).sort(0);
        this.updateModel();
    }

    public Action getBrowseDirectoryAction() {
        return this.browseAction;
    }

    public Action getResetDirectoryAction() {
        return this.resetAction;
    }

    @Override
    public void removeSelection() {
    }

    @Override
    protected void updateSplashScreen() {
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(this.browseAction));
        jPopupMenu.add(new JMenuItem(this.resetAction));
        return jPopupMenu;
    }

    @Override
    public void handleHeaderPopupMenu(Point point) {
    }

    @Override
    public void handleActionKey() {
    }

    @Override
    public void handleSelection(int n) {
        this.browseAction.setEnabled(true);
        this.resetAction.setEnabled(true);
    }

    @Override
    public void handleNoSelection() {
        this.browseAction.setEnabled(false);
        this.resetAction.setEnabled(false);
    }

    private void updateModel() {
        String string = this.saveField.getText();
        for (int i = 0; i < this.TABLE.getRowCount(); ++i) {
            MediaTypeDownloadDirDataLine mediaTypeDownloadDirDataLine = (MediaTypeDownloadDirDataLine)((MediaTypeDownloadDirModel)this.DATA_MODEL).get(i);
            mediaTypeDownloadDirDataLine.setDefaultDir(string);
        }
        ((MediaTypeDownloadDirModel)this.DATA_MODEL).fireTableDataChanged();
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            MediaTypeDownloadDirMediator.this.updateModel();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            MediaTypeDownloadDirMediator.this.updateModel();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }

    private class ResetDirectoryAction
    extends AbstractAction {
        public ResetDirectoryAction() {
            this.putValue("Name", I18n.tr("Reset"));
            this.putValue("ShortDescription", I18n.tr("Reset to Default Download Folder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MediaTypeDownloadDirDataLine mediaTypeDownloadDirDataLine = (MediaTypeDownloadDirDataLine)((MediaTypeDownloadDirModel)MediaTypeDownloadDirMediator.this.DATA_MODEL).get(MediaTypeDownloadDirMediator.this.TABLE.getSelectedRow());
            if (mediaTypeDownloadDirDataLine == null) {
                throw new IllegalArgumentException("reset action was not correctly disabled");
            }
            mediaTypeDownloadDirDataLine.reset();
            ((MediaTypeDownloadDirModel)MediaTypeDownloadDirMediator.this.DATA_MODEL).fireTableDataChanged();
        }
    }

    private class BrowseDirectoryAction
    extends AbstractAction {
        public BrowseDirectoryAction() {
            this.putValue("Name", I18n.tr("Browse..."));
            this.putValue("ShortDescription", I18n.tr("Open Dialog to Select a Folder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MediaTypeDownloadDirDataLine mediaTypeDownloadDirDataLine = (MediaTypeDownloadDirDataLine)((MediaTypeDownloadDirModel)MediaTypeDownloadDirMediator.this.DATA_MODEL).get(MediaTypeDownloadDirMediator.this.TABLE.getSelectedRow());
            if (mediaTypeDownloadDirDataLine == null) {
                throw new IllegalArgumentException("browse action was not correctly disabled");
            }
            File file = FileChooserHandler.getInputDirectory(OptionsMediator.instance().getMainOptionsComponent(), new File(mediaTypeDownloadDirDataLine.getVisibleDirectoryString()));
            if (file != null) {
                mediaTypeDownloadDirDataLine.setDirectory(file);
            }
        }
    }
}

