/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.ListEditor;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.FilterSettings;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.limewire.io.IP;

public final class IgnoreMessagesPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Filter Hosts");
    public static final String LABEL = I18n.tr("You can disallow messages from specific hosts by adding their IP addresses (e.g. \"192.168.0.1\", \"192.*.*.*\", \"192.168.12.16/255.255.255.240\" or \"192.168.12.16/28\") to the banned list.");
    private final ListEditor MESSAGES_LIST = new ListEditor();
    private final JCheckBox networkBlackList = new JCheckBox();

    public IgnoreMessagesPaneItem() {
        super(TITLE, LABEL);
        this.add(this.MESSAGES_LIST);
        this.MESSAGES_LIST.addListDataListener(new IPEnforcer());
        this.add(this.getVerticalSeparator());
        this.addLabel(I18n.tr("FrostWire can also manage a blacklist for you.  This will keep FrostWire protected from harmful clients and other nuisances."));
        LabeledComponent labeledComponent = new LabeledComponent(I18n.tr("Use FrostWire's built-in blacklist"), this.networkBlackList, 120, 10);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        String[] stringArray = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
        this.MESSAGES_LIST.setModel(new Vector<String>(Arrays.asList(stringArray)));
        this.networkBlackList.setSelected(FilterSettings.USE_NETWORK_FILTER.getValue());
    }

    public boolean applyOptions() throws IOException {
        Vector<String> vector = this.MESSAGES_LIST.getModel();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        FilterSettings.USE_NETWORK_FILTER.setValue(this.networkBlackList.isSelected());
        FilterSettings.BLACK_LISTED_IP_ADDRESSES.setValue((String[])objectArray);
        GuiCoreMediator.getSpamServices().reloadIPFilter();
        return false;
    }

    public boolean isDirty() {
        List<String> list = Arrays.asList(FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue());
        return this.networkBlackList.isSelected() != FilterSettings.USE_NETWORK_FILTER.getValue() || !((Object)list).equals(this.MESSAGES_LIST.getModel());
    }

    private class IPEnforcer
    implements ListDataListener {
        private IPEnforcer() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            Vector vector = (Vector)listDataEvent.getSource();
            String string = (String)vector.get(listDataEvent.getIndex0());
            try {
                new IP(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                IgnoreMessagesPaneItem.this.MESSAGES_LIST.removeItem(listDataEvent.getIndex0());
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            Vector vector = (Vector)listDataEvent.getSource();
            String string = (String)vector.get(listDataEvent.getIndex0());
            try {
                new IP(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String[] stringArray = FilterSettings.BLACK_LISTED_IP_ADDRESSES.getValue();
                IgnoreMessagesPaneItem.this.MESSAGES_LIST.setModel(new Vector<String>(Arrays.asList(stringArray)));
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

