/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.DownloadSettings;
import java.awt.Font;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.limewire.i18n.I18nMarker;

public final class DownloadBandwidthPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Download Bandwidth");
    public static final String LABEL = I18n.tr("You can set the percentage of your bandwidth devoted to downloads.");
    private final String LABEL_LABEL = I18nMarker.marktr("Download Speed:");
    private final String SLIDER_MAX_LABEL = I18nMarker.marktr("Unlimited");
    private final JSlider DOWNLOAD_SLIDER = new JSlider(5, 100);
    private final JLabel SLIDER_LABEL = new JLabel();
    private int _downloadThrottle;

    public DownloadBandwidthPaneItem() {
        super(TITLE, LABEL);
        this.DOWNLOAD_SLIDER.setMajorTickSpacing(10);
        this.DOWNLOAD_SLIDER.setPaintTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        JLabel jLabel = new JLabel("1%");
        JLabel jLabel2 = new JLabel("100%");
        Font font = new Font("Helvetica", 1, 10);
        jLabel.setFont(font);
        jLabel2.setFont(font);
        hashtable.put(new Integer(1), jLabel);
        hashtable.put(new Integer(100), jLabel2);
        this.DOWNLOAD_SLIDER.setLabelTable(hashtable);
        this.DOWNLOAD_SLIDER.setPaintLabels(true);
        this.DOWNLOAD_SLIDER.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DownloadBandwidthPaneItem.this.handleThrottleLabel();
            }
        });
        LabeledComponent labeledComponent = new LabeledComponent(this.LABEL_LABEL, this.SLIDER_LABEL, 120, 10);
        this.add(this.DOWNLOAD_SLIDER);
        this.add(this.getVerticalSeparator());
        this.add(labeledComponent.getComponent());
    }

    private void handleThrottleLabel() {
        float f = this.DOWNLOAD_SLIDER.getValue();
        String string = "";
        if (f == 100.0f) {
            string = I18n.tr(this.SLIDER_MAX_LABEL);
        } else {
            Float f2 = new Float((double)this.DOWNLOAD_SLIDER.getValue() / 100.0 * (double)ConnectionSettings.CONNECTION_SPEED.getValue() / 8.0);
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            string = String.valueOf(numberFormat.format(f2)) + " KB/s";
        }
        this.SLIDER_LABEL.setText(string);
    }

    public void initOptions() {
        this._downloadThrottle = DownloadSettings.DOWNLOAD_SPEED.getValue();
        this.DOWNLOAD_SLIDER.setValue(this._downloadThrottle);
        this.handleThrottleLabel();
    }

    public boolean applyOptions() throws IOException {
        int n = this.DOWNLOAD_SLIDER.getValue();
        if (n != this._downloadThrottle) {
            DownloadSettings.DOWNLOAD_SPEED.setValue(n);
            this._downloadThrottle = n;
            GuiCoreMediator.getBandwidthManager().applyRate();
        }
        return false;
    }

    public boolean isDirty() {
        return DownloadSettings.DOWNLOAD_SPEED.getValue() != this.DOWNLOAD_SLIDER.getValue();
    }
}

