/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import org.limewire.i18n.I18nMarker;

public class DefaultActionPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("File Already Exists Behavior");
    public static final String LABEL = I18n.tr("You can choose the default action that FrostWire will perform when you try to download a file that already exists on disk.");
    private JRadioButton saveAs;
    private JRadioButton append;
    private JRadioButton ask;

    public DefaultActionPaneItem() {
        super(TITLE, LABEL);
        BoxPanel boxPanel = new BoxPanel();
        String string = I18nMarker.marktr("Always Show the 'Save As' Dialog");
        String string2 = I18nMarker.marktr("Always Append (#) to the Filename");
        String string3 = I18nMarker.marktr("Always Ask What to do");
        this.saveAs = new JRadioButton(I18n.tr(string));
        this.append = new JRadioButton(I18n.tr(string2));
        this.ask = new JRadioButton(I18n.tr(string3));
        ButtonGroup buttonGroup = new ButtonGroup();
        boxPanel.add(this.ask);
        boxPanel.add(this.saveAs);
        boxPanel.add(this.append);
        buttonGroup.add(this.ask);
        buttonGroup.add(this.saveAs);
        buttonGroup.add(this.append);
        BoxPanel boxPanel2 = new BoxPanel(0);
        boxPanel2.add(boxPanel);
        boxPanel2.add(Box.createHorizontalGlue());
        this.add(boxPanel2);
    }

    public boolean applyOptions() throws IOException {
        if (this.ask.isSelected()) {
            QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.setValue(0);
        } else if (this.append.isSelected()) {
            QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.setValue(1);
        } else if (this.saveAs.isSelected()) {
            QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.setValue(2);
        }
        return false;
    }

    public void initOptions() {
        int n = QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.getValue();
        if (n == 0) {
            this.ask.setSelected(true);
        } else if (n == 1) {
            this.append.setSelected(true);
        } else if (n == 2) {
            this.saveAs.setSelected(true);
        }
    }

    public boolean isDirty() {
        int n = -1;
        if (this.ask.isSelected()) {
            n = 0;
        } else if (this.append.isSelected()) {
            n = 1;
        } else if (this.saveAs.isSelected()) {
            n = 2;
        }
        return QuestionsHandler.DEFAULT_ACTION_FILE_EXISTS.getValue() != n;
    }
}

