/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ChatSettings;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;

public final class ChatCommunityPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Community Chat");
    public static final String LABEL = I18n.tr("FrostWire's Community Chat Tab requires you to have a nickname to communicate with others in the chatrooms");
    private final String NAME_LABEL = I18nMarker.marktr("Type your chat nickname here (any name):");
    private JTextField _ircNickField = new SizedTextField(15, GUIUtils.SizePolicy.RESTRICT_HEIGHT);

    public ChatCommunityPaneItem() {
        super(TITLE, LABEL);
        LabeledComponent labeledComponent = new LabeledComponent(this.NAME_LABEL, this._ircNickField);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this._ircNickField.setText(ChatSettings.CHAT_IRC_NICK.getValue());
    }

    public boolean applyOptions() throws IOException {
        if (!this.checkChatNickIsNotFWGuest()) {
            return false;
        }
        ChatSettings.CHAT_IRC_NICK.setValue(this._ircNickField.getText());
        GUIMediator.instance().tryToStartAndAddChat();
        GUIMediator.instance().setIRCNick(ChatSettings.CHAT_IRC_NICK.getValue());
        return true;
    }

    public boolean isDirty() {
        return !ChatSettings.CHAT_IRC_NICK.getValue().equals(this._ircNickField.getText());
    }

    public boolean checkChatNickIsNotFWGuest() {
        String string = this._ircNickField.getText().toLowerCase().trim();
        if (ChatSettings.CHAT_IRC_ENABLED.getValue() && (string.equals("") || string.startsWith("fw_guest"))) {
            JOptionPane.showMessageDialog(GUIMediator.getAppFrame(), I18n.tr("The chosen nickname is not allowed."), I18n.tr("Warning: Forbidden name!"), 2);
            return false;
        }
        return true;
    }
}

