/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ListEditor;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.FilterSettings;
import java.awt.Toolkit;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.limewire.io.IP;

public final class AllowMessagesPaneItem
extends AbstractPaneItem {
    public static final String TITLE = I18n.tr("Allow Hosts");
    public static final String LABEL = I18n.tr("You can allow messages from specific hosts by adding their IP addresses (e.g. \"192.168.0.1\", \"192.*.*.*\", \"192.168.12.16/255.255.255.240\" or \"192.168.12.16/28\") to the allow list. This list is only needed to override the banned list.");
    private final ListEditor MESSAGES_LIST = new ListEditor();

    public AllowMessagesPaneItem() {
        super(TITLE, LABEL);
        this.add(this.MESSAGES_LIST);
        this.MESSAGES_LIST.addListDataListener(new IPEnforcer());
    }

    public void initOptions() {
        String[] stringArray = FilterSettings.WHITE_LISTED_IP_ADDRESSES.getValue();
        this.MESSAGES_LIST.setModel(new Vector<String>(Arrays.asList(stringArray)));
    }

    public boolean applyOptions() throws IOException {
        Vector<String> vector = this.MESSAGES_LIST.getModel();
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        FilterSettings.WHITE_LISTED_IP_ADDRESSES.setValue((String[])objectArray);
        GuiCoreMediator.getSpamServices().reloadIPFilter();
        return false;
    }

    public boolean isDirty() {
        List<String> list = Arrays.asList(FilterSettings.WHITE_LISTED_IP_ADDRESSES.getValue());
        return !((Object)list).equals(this.MESSAGES_LIST.getModel());
    }

    private class IPEnforcer
    implements ListDataListener {
        private IPEnforcer() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            Vector vector = (Vector)listDataEvent.getSource();
            String string = (String)vector.get(listDataEvent.getIndex0());
            try {
                new IP(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                AllowMessagesPaneItem.this.MESSAGES_LIST.removeItem(listDataEvent.getIndex0());
                Toolkit.getDefaultToolkit().beep();
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            Vector vector = (Vector)listDataEvent.getSource();
            String string = (String)vector.get(listDataEvent.getIndex0());
            try {
                new IP(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String[] stringArray = FilterSettings.WHITE_LISTED_IP_ADDRESSES.getValue();
                AllowMessagesPaneItem.this.MESSAGES_LIST.setModel(new Vector<String>(Arrays.asList(stringArray)));
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

