/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.frostwire.actions.ConnectionDoctorAction;
import com.frostwire.updates.UpdateManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.limewire.i18n.I18nMarker;

final class ToolsMenu
extends AbstractMenu {
    ToolsMenu() {
        super(I18n.tr("&Tools"));
        this.addMenuItem(new CheckForUpdatesAction());
        this.addMenuItem(ConnectionDoctorAction.getInstance());
        this.addMenuItem(new ShowOptionsAction());
    }

    private static class ShowOptionsAction
    extends AbstractAction {
        public ShowOptionsAction() {
            super(I18n.tr("&Options"));
            this.putValue("LongDescription", I18nMarker.marktr("Display the Options Screen"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.instance().setOptionsVisible(true);
        }
    }

    private static class CheckForUpdatesAction
    extends AbstractAction {
        private final long TIME_BETWEEN_CHECKS = 300000L;
        private long lastTimeWeChecked = 0L;
        private Thread enabler;

        public CheckForUpdatesAction() {
            super(I18n.tr("&Check for updates"));
            this.putValue("LongDescription", I18nMarker.marktr("Check for new FrostWire updates or automatic configuration updates"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            long l;
            this.lastTimeWeChecked = l = new Date().getTime();
            UpdateManager.scheduleUpdateCheckTask(0);
            this.setEnabled(false);
            this.enabler = new Thread(){

                public void run() {
                    long l = new Date().getTime();
                    int n = (int)((300000L - (l - CheckForUpdatesAction.this.lastTimeWeChecked)) / 1000L);
                    long l2 = l + 300000L;
                    try {
                        while (l < l2) {
                            l = new Date().getTime();
                            CheckForUpdatesAction.this.putValue("Name", I18n.tr("&Check for updates") + " (" + n + " " + I18n.tr("seconds left)"));
                            n = (int)((300000L - (l - CheckForUpdatesAction.this.lastTimeWeChecked)) / 1000L);
                            1.sleep(500L);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CheckForUpdatesAction.this.putValue("Name", I18n.tr("&Check for updates"));
                    CheckForUpdatesAction.this.setEnabled(true);
                }
            };
            this.enabler.start();
        }
    }
}

