/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.actions.OpenLinkAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ThemeMenu
extends AbstractMenu {
    private static final String THEME_PROPERTY = "THEME_NAME";
    private static final String THEME_CLASSNAME = "THEME_CLASSNAME";
    private static final Action THEME_CHANGER = new ThemeChangeAction();
    private static final ButtonGroup GROUP = new ButtonGroup();

    ThemeMenu() {
        super(I18n.tr("&Apply Skins"));
        this.addMenuItem(new OpenLinkAction("http://www.frostwire.com/beta/skins/", I18n.tr("&Get More Skins"), I18n.tr("Find more skins from frostwire.com")));
        this.addMenuItem(new RefreshThemesAction());
        JMenuItem jMenuItem = this.addMenuItem(THEME_CHANGER);
        final String string = ThemeSettings.THEME_DEFAULT.getAbsolutePath();
        jMenuItem.putClientProperty(THEME_PROPERTY, string);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThemeMenu.setSelection(string);
            }
        });
        this.addSeparator();
        this.addThemeItems();
    }

    private static void setSelection(Object object) {
        Enumeration<AbstractButton> enumeration = GROUP.getElements();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
            if (!object.equals(jMenuItem.getClientProperty(THEME_PROPERTY))) continue;
            jMenuItem.setSelected(true);
            break;
        }
    }

    private void addThemeItems() {
        File file = ThemeSettings.THEME_DIR_FILE;
        if (!file.exists()) {
            return;
        }
        TreeSet<Object> treeSet = new TreeSet<Object>(new ThemeComparator());
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".fwtp");
            }
        });
        if (stringArray != null && stringArray.length > 0) {
            treeSet.addAll(Arrays.asList(stringArray));
        }
        treeSet.addAll(ThemeSettings.JAR_THEME_NAMES);
        Object object = treeSet.iterator();
        while (object.hasNext()) {
            if (this.isAllowedThemeFilename((String)object.next())) continue;
            object.remove();
        }
        ThemeMenu.addInstalledLFs(treeSet);
        if (treeSet.isEmpty()) {
            return;
        }
        object = ThemeSettings.getOtherLF();
        for (Object e : treeSet) {
            JRadioButtonMenuItem jRadioButtonMenuItem;
            File file2;
            if (e instanceof String) {
                file2 = new File(file, (String)e);
                jRadioButtonMenuItem = new JRadioButtonMenuItem(ThemeSettings.formatName(file2.getName()));
                if (file2.equals(ThemeSettings.THEME_FILE.getValue())) {
                    jRadioButtonMenuItem.setSelected(true);
                }
            } else {
                file2 = new File(file, "other_theme.fwtp");
                UIManager.LookAndFeelInfo lookAndFeelInfo = (UIManager.LookAndFeelInfo)e;
                jRadioButtonMenuItem = new JRadioButtonMenuItem(lookAndFeelInfo.getName());
                if (file2.equals(ThemeSettings.THEME_FILE.getValue()) && object != null && lookAndFeelInfo.getClassName().equals(object)) {
                    jRadioButtonMenuItem.setSelected(true);
                }
                jRadioButtonMenuItem.putClientProperty(THEME_CLASSNAME, lookAndFeelInfo.getClassName());
            }
            jRadioButtonMenuItem.setFont(AbstractMenu.FONT);
            GROUP.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.addActionListener(THEME_CHANGER);
            jRadioButtonMenuItem.putClientProperty(THEME_PROPERTY, file2.getAbsolutePath());
            this.MENU.add(jRadioButtonMenuItem);
        }
    }

    private void removeThemeItems() {
        Enumeration<AbstractButton> enumeration = GROUP.getElements();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem = (JMenuItem)enumeration.nextElement();
            this.MENU.remove(jMenuItem);
            linkedList.add(jMenuItem);
        }
        for (JMenuItem jMenuItem : linkedList) {
            GROUP.remove(jMenuItem);
        }
    }

    private static void addInstalledLFs(Set<Object> set) {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        if (lookAndFeelInfoArray == null) {
            return;
        }
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = lookAndFeelInfoArray[i];
            if (lookAndFeelInfo.getClassName().equals("com.sun.java.swing.plaf.windows.WindowsLookAndFeel") || lookAndFeelInfo.getClassName().contains("javax.swing.plaf.metal.MetalLookAndFeel") || lookAndFeelInfo.getClassName().startsWith("apple") || lookAndFeelInfo.getClassName().equals("com.sun.java.swing.plaf.gtk.GTKLookAndFeel") && OSUtils.isLinux() || lookAndFeelInfo.getClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel") || lookAndFeelInfo.getClassName().equals("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel") || lookAndFeelInfo.getClassName().equals("com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel")) continue;
            set.add(lookAndFeelInfo);
        }
    }

    private boolean isAllowedThemeFilename(String string) {
        if (!string.endsWith("fwtp")) {
            return false;
        }
        if (string.startsWith("default_")) {
            return false;
        }
        if (string.equals("other_theme.fwtp")) {
            return false;
        }
        if (!OSUtils.isMacOSX() && string.equals("pinstripes_theme_osx.fwtp")) {
            return false;
        }
        if (!OSUtils.isMacOSX() && string.equals("brushed_metal_theme_osx.fwtp")) {
            return false;
        }
        if (!OSUtils.isWindows() && string.equals("windows_theme.fwtp")) {
            return false;
        }
        if (!LimeWireUtils.isPro() && string.equals("frostwirePro_theme.fwtp")) {
            return false;
        }
        return !string.equals("GTK_theme.fwtp") || OSUtils.isLinux();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ThemeComparator
    implements Comparator<Object> {
        private ThemeComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            String string = object instanceof String ? ThemeSettings.formatName((String)object) : ((UIManager.LookAndFeelInfo)object).getName();
            String string2 = object2 instanceof String ? ThemeSettings.formatName((String)object2) : ((UIManager.LookAndFeelInfo)object2).getName();
            return string.compareTo(string2);
        }
    }

    protected static class ThemeChangeAction
    extends AbstractAction {
        public ThemeChangeAction() {
            super(I18n.tr("Use &Default"));
            this.putValue("LongDescription", I18n.tr("Use your default skin"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            String string = (String)jMenuItem.getClientProperty(ThemeMenu.THEME_PROPERTY);
            String string2 = (String)jMenuItem.getClientProperty(ThemeMenu.THEME_CLASSNAME);
            ThemeMediator.changeTheme(new File(string), string2);
        }
    }

    private class RefreshThemesAction
    extends AbstractAction {
        private static final long serialVersionUID = 3056020209833157854L;

        public RefreshThemesAction() {
            super(I18n.tr("&Refresh Skins"));
            this.putValue("LongDescription", I18n.tr("Reload available skins from disk"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ThemeMenu.this.removeThemeItems();
            ThemeMenu.this.addThemeItems();
        }
    }
}

