/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.dht.DHTEvent;
import com.limegroup.gnutella.dht.DHTEventListener;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.limewire.mojito.Context;
import org.limewire.mojito.MojitoDHT;
import org.limewire.mojito.visual.ArcsVisualizer;

public class AdvancedMenu
extends AbstractMenu {
    private final EnabledListener enabledListener = new EnabledListener(this.getMenu());

    AdvancedMenu() {
        super(I18n.tr("&Advanced"));
        ArcsAction arcsAction = new ArcsAction();
        this.addMenuItem(arcsAction);
        GuiCoreMediator.getDHTManager().addEventListener(arcsAction);
    }

    protected JMenuItem addMenuItem(Action action) {
        action.addPropertyChangeListener(this.enabledListener);
        if (action.isEnabled()) {
            this.enabledListener.change(true);
        }
        return super.addMenuItem(action);
    }

    private static class ArcsAction
    extends AbstractAction
    implements DHTEventListener {
        public ArcsAction() {
            super(I18n.tr("Mojito &DHT Arcs View"));
            this.putValue("LongDescription", I18n.tr("Display a view of the incoming and outgoing DHT messages"));
            this.setEnabled(GuiCoreMediator.getDHTManager().isRunning());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MojitoDHT mojitoDHT = GuiCoreMediator.getDHTManager().getMojitoDHT();
            if (mojitoDHT != null) {
                ArcsVisualizer.show((Context)((Context)mojitoDHT));
            }
        }

        public void handleDHTEvent(DHTEvent dHTEvent) {
            this.setEnabledLater(dHTEvent.getType() != DHTEvent.Type.STOPPED);
        }
    }

    private static class EnabledListener
    implements PropertyChangeListener {
        private final JMenu mainMenu;
        private int enableds;

        public EnabledListener(JMenu jMenu) {
            this.mainMenu = jMenu;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.change((Boolean)propertyChangeEvent.getNewValue());
            }
        }

        void change(boolean bl) {
            this.enableds = bl ? ++this.enableds : --this.enableds;
            if (this.enableds > 0) {
                this.mainMenu.setEnabled(true);
            } else {
                this.mainMenu.setEnabled(false);
            }
        }
    }
}

