/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.logging;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.logging.LogEvent;
import com.limegroup.gnutella.gui.logging.LoggingDataLine;
import com.limegroup.gnutella.gui.logging.LoggingModel;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggingMediator
extends AbstractTableMediator<LoggingModel, LoggingDataLine, LogEvent> {
    private static final int MAXIMUM_EVENT_SIZE = 250;
    private static final LoggingMediator INSTANCE = new LoggingMediator();

    public static LoggingMediator instance() {
        return INSTANCE;
    }

    private LoggingMediator() {
        super("LOGGING_TABLE");
        GUIMediator.addRefreshListener(this);
        ThemeMediator.addThemeObserver(this);
        this.doRefresh();
    }

    @Override
    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(I18n.tr("Logging"));
        this.DATA_MODEL = new LoggingModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
    }

    @Override
    protected void setupDragAndDrop() {
        this.TABLE.setTransferHandler(DNDUtils.DEFAULT_TRANSFER_HANDLER);
    }

    @Override
    public void add(LogEvent logEvent) {
        if (this.getSize() >= 250) {
            ((LoggingModel)this.DATA_MODEL).removeOldestTime();
        }
        super.add(logEvent);
    }

    @Override
    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Logging Window..."));
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        return null;
    }

    @Override
    public void handleActionKey() {
    }

    @Override
    public void handleNoSelection() {
    }

    @Override
    public void handleSelection(int n) {
    }
}

