/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.dnd.CompositeTransferable;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.FileTransferable;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableDataLine;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.library.LibraryTableTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JComponent;

public class LibraryTableTransferHandler
extends LimeTransferHandler {
    public LibraryTableTransferHandler() {
        super(3);
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (!DNDUtils.containsLibraryFlavors(dataFlavorArray)) {
            return false;
        }
        return DNDUtils.DEFAULT_TRANSFER_HANDLER.canImport(jComponent, dataFlavorArray);
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        return this.canImport(jComponent, dataFlavorArray);
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        return DNDUtils.DEFAULT_TRANSFER_HANDLER.importData(jComponent, transferable);
    }

    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        return this.importData(jComponent, transferable);
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        File[] fileArray;
        if (n != 2) {
            return;
        }
        if (!DNDUtils.containsFileFlavors(transferable.getTransferDataFlavors())) {
            return;
        }
        try {
            fileArray = DNDUtils.getFiles(transferable);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return;
        }
        catch (IOException iOException) {
            return;
        }
        boolean bl = false;
        FileManager fileManager = GuiCoreMediator.getFileManager();
        for (File file : fileArray) {
            FileDesc fileDesc;
            if (file.exists() || (fileDesc = fileManager.removeFileIfShared(file)) != null) continue;
            bl = true;
            fileManager.loadSettings();
            break;
        }
        if (!bl) {
            LibraryMediator.instance().forceRefresh();
        }
        GUIMediator.instance().refreshGUI();
    }

    protected Transferable createTransferable(JComponent jComponent) {
        LibraryTableDataLine[] libraryTableDataLineArray = LibraryTableMediator.instance().getSelectedLibraryLines();
        if (libraryTableDataLineArray.length == 0) {
            return null;
        }
        LibraryTableTransferable libraryTableTransferable = new LibraryTableTransferable(libraryTableDataLineArray);
        FileTransferable fileTransferable = new FileTransferable(FileTransferable.EMPTY_FILE_LIST, Arrays.asList(libraryTableDataLineArray));
        return new CompositeTransferable(libraryTableTransferable, fileTransferable);
    }
}

