/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.library.FileSettingDirectoryHolder;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;
import javax.swing.Icon;

public class IncompleteDirectoryHolder
extends FileSettingDirectoryHolder {
    public IncompleteDirectoryHolder() {
        super(SharingSettings.INCOMPLETE_DIRECTORY, I18n.tr("Incomplete Files"));
    }

    public boolean accept(File file) {
        String string = file.getName();
        return super.accept(file) && !file.isHidden() && !string.startsWith(".") && this.isAppropriateType(file) && !string.equals("downloads.dat") && !string.equals("downloads.bak");
    }

    public Icon getIcon() {
        return GUIMediator.getThemeImage("incomplete");
    }

    private boolean isAppropriateType(File file) {
        if (file.isFile()) {
            return true;
        }
        return IncompleteFileManager.isTorrentFolder(file);
    }
}

