/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.actions.RemoveSharedDirectoryAction;
import com.limegroup.gnutella.gui.actions.SelectSharedDirectoryAction;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.library.RecursiveSharingPanel;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.CommonUtils;
import org.limewire.util.StringUtils;

class SaveWindow
extends SetupWindow {
    private static final String LEARN_MORE_URL = "http://www.frostwire.com";
    private final JTextField SAVE_FIELD = new JTextField(20);
    private String _defaultSaveDir;
    private final RecursiveSharingPanel recursiveSharingPanel;

    SaveWindow(SetupManager setupManager, boolean bl) {
        super(setupManager, I18nMarker.marktr("Save Folder and Shared Folders"), SaveWindow.describeText(bl), LEARN_MORE_URL);
        File file = new File(CommonUtils.getUserHomeDir(), "Shared");
        if (file.exists()) {
            SharingSettings.DIRECTORIES_TO_SHARE.add(file);
        }
        this.recursiveSharingPanel = new RecursiveSharingPanel(new File[0]);
        this.recursiveSharingPanel.getTree().setRootVisible(false);
        this.recursiveSharingPanel.getTree().setShowsRootHandles(true);
        this.recursiveSharingPanel.setRoots(SharingSettings.DIRECTORIES_TO_SHARE.getValueAsArray());
        this.recursiveSharingPanel.addRoot(SharingSettings.DEFAULT_SHARE_DIR);
        this.recursiveSharingPanel.setFoldersToExclude(GuiCoreMediator.getFileManager().getFolderNotToShare());
        this.recursiveSharingPanel.setRootsExpanded();
    }

    private static String describeText(boolean bl) {
        if (!bl) {
            return I18nMarker.marktr("Please choose a folder where you would like your files to be downloaded. You can also choose folders you would like to share with other users running FrostWire.");
        }
        return I18nMarker.marktr("FrostWire now downloads files to a new, different folder.  Please confirm the folder where you would like your files to be downloaded. You can also choose folders you would like to share with other users running FrostWire.");
    }

    protected void createWindow() {
        super.createWindow();
        this.recursiveSharingPanel.updateLanguage();
        File file = SharingSettings.getSaveDirectory();
        try {
            this._defaultSaveDir = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this._defaultSaveDir = file.getAbsolutePath();
        }
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)new JLabel(I18n.tr("Save Folder")), gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.SAVE_FIELD, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)new ButtonRow(new Action[]{new DefaultAction(), new BrowseAction()}, 0, 12), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)new JLabel(I18n.tr("Shared Folders")), gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridwidth = -1;
        jPanel2.add((Component)this.recursiveSharingPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        jPanel2.add((Component)new JButton(new SelectSharedDirectoryAction(this.recursiveSharingPanel, this._manager.getOwnerComponent())), gridBagConstraints);
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        jPanel2.add((Component)new JButton(new RemoveSharedDirectoryAction(this.recursiveSharingPanel)), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        try {
            this.SAVE_FIELD.setText(this._defaultSaveDir);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.setSetupComponent(jPanel);
    }

    public void applySettings(boolean bl) throws ApplySettingsException {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>(2);
        try {
            object2 = this.SAVE_FIELD.getText();
            object = new File((String)object2);
            if (bl) {
                if (!SaveDirectoryHandler.showVistaWarningIfNeeded((File)object)) {
                    throw new ApplySettingsException();
                }
                if (!((File)object).isDirectory() && !((File)object).mkdirs()) {
                    throw new IOException();
                }
            }
            SharingSettings.setSaveDirectory((File)object);
        }
        catch (IOException iOException) {
            arrayList.add(I18n.tr("FrostWire was unable to use the specified folder for saving files. Please try a different folder."));
        }
        object2 = SharingSettings.DEFAULT_SHARE_DIR;
        object = this.recursiveSharingPanel.getRootsToShare();
        if (object.contains(object2)) {
            if (((File)object2).isFile()) {
                arrayList.add(I18n.tr("FrostWire could not create default share folder {0}, a file with that name already exists.", object2));
            } else if (!((File)object2).isDirectory() && !((File)object2).mkdirs()) {
                arrayList.add(I18n.tr("FrostWire could not create default share folder {0}, it will not be shared.", object2));
            }
        }
        if (bl) {
            GuiCoreMediator.getFileManager().loadWithNewDirectories((Set<? extends File>)object, this.recursiveSharingPanel.getFoldersToExclude());
        }
        if (!arrayList.isEmpty()) {
            throw new ApplySettingsException(StringUtils.explode(arrayList, "\n\n"));
        }
    }

    private class BrowseAction
    extends AbstractAction {
        public BrowseAction() {
            this.putValue("Name", I18n.tr("Browse..."));
            this.putValue("ShortDescription", I18n.tr("Choose Another Folder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = FileChooserHandler.getInputDirectory(SaveWindow.this);
            if (file == null || !file.isDirectory()) {
                return;
            }
            SaveWindow.this.SAVE_FIELD.setText(file.getAbsolutePath());
        }
    }

    private class DefaultAction
    extends AbstractAction {
        public DefaultAction() {
            this.putValue("Name", I18n.tr("Use Default"));
            this.putValue("ShortDescription", I18n.tr("Use the Default Folder"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SaveWindow.this.SAVE_FIELD.setText(SaveWindow.this._defaultSaveDir);
        }
    }
}

