/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.download.GuiDownloaderFactory;
import com.limegroup.gnutella.settings.SharingSettings;
import java.io.File;

public class StoreDownloaderFactory
implements GuiDownloaderFactory {
    private final RemoteFileDesc rfd;
    private File saveDir;
    private String fileName;

    public StoreDownloaderFactory(RemoteFileDesc remoteFileDesc, String string) {
        this.rfd = remoteFileDesc;
        this.fileName = string != null ? string : remoteFileDesc.getFileName();
        this.saveDir = SharingSettings.getSaveLWSDirectory();
    }

    public File getSaveFile() {
        return new File(this.saveDir, this.fileName);
    }

    public void setSaveFile(File file) {
        if (file != null && !file.isDirectory()) {
            this.fileName = file.getName();
            this.saveDir = file.getParentFile();
        }
    }

    public URN getURN() {
        return this.rfd.getSHA1Urn();
    }

    public long getFileSize() {
        return this.rfd.getSize();
    }

    public String download() {
        Downloader downloader = null;
        try {
            downloader = this.createDownloader(true);
        }
        catch (SaveLocationException saveLocationException) {
            // empty catch block
        }
        return String.valueOf(System.identityHashCode(downloader));
    }

    public Downloader createDownloader(boolean bl) throws SaveLocationException {
        return GuiCoreMediator.getDownloadServices().downloadFromStore(this.rfd, bl, this.saveDir, this.fileName);
    }
}

