/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.download;

import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.SaveLocationException;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.browser.MagnetOptions;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.download.DownloaderDialog;
import com.limegroup.gnutella.gui.download.GuiDownloaderFactory;
import com.limegroup.gnutella.gui.download.MagnetDownloaderFactory;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Component;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.OSUtils;

public class DownloaderUtils {
    public static Downloader createDownloader(GuiDownloaderFactory guiDownloaderFactory) {
        if (DownloaderUtils.isAlreadyDownloading(guiDownloaderFactory)) {
            return null;
        }
        if (!DownloaderUtils.isSaveLocationTaken(guiDownloaderFactory) && !DownloaderUtils.continueWithOrWithoutHashConflict(guiDownloaderFactory)) {
            return null;
        }
        return DownloaderUtils.createDownloader(guiDownloaderFactory, false);
    }

    public static Downloader createDownloaderAs(GuiDownloaderFactory guiDownloaderFactory) {
        if (DownloaderUtils.isAlreadyDownloading(guiDownloaderFactory)) {
            return null;
        }
        if (!DownloaderUtils.continueWithOrWithoutHashConflict(guiDownloaderFactory)) {
            return null;
        }
        File file = DownloaderUtils.showFileChooser(guiDownloaderFactory, MessageService.getParentComponent());
        if (file == null) {
            return null;
        }
        guiDownloaderFactory.setSaveFile(file);
        return DownloaderUtils.createDownloader(guiDownloaderFactory, OSUtils.isAnyMac());
    }

    public static Downloader createDownloader(MagnetOptions magnetOptions) {
        String string = magnetOptions.getErrorMessage();
        if (!magnetOptions.isDownloadable()) {
            if (string == null) {
                string = magnetOptions.toString();
            }
            GUIMediator.showError(I18n.tr("Could not process bad MAGNET link {0}", string));
            return null;
        }
        if (string != null) {
            GUIMediator.showWarning(I18n.tr("One or more URLs in the MAGNET link were invalid. Your file may not download correctly."));
        }
        MagnetDownloaderFactory magnetDownloaderFactory = new MagnetDownloaderFactory(magnetOptions);
        if (magnetOptions.getDisplayName() == null) {
            Downloader downloader = DownloaderUtils.createDownloaderAs(magnetDownloaderFactory);
            if (downloader != null && magnetOptions.isHashOnly()) {
                GUIMediator.showError(I18n.tr("FrostWire may not be able to start the download you have selected unless you start a search for it."));
            }
            return downloader;
        }
        return DownloaderUtils.createDownloader(magnetDownloaderFactory);
    }

    public static Downloader createDownloader(GuiDownloaderFactory guiDownloaderFactory, boolean bl) {
        try {
            return guiDownloaderFactory.createDownloader(bl);
        }
        catch (SaveLocationException saveLocationException) {
            return DownloaderDialog.handle(guiDownloaderFactory, saveLocationException);
        }
    }

    public static boolean isAlreadyDownloading(GuiDownloaderFactory guiDownloaderFactory) {
        if (GuiCoreMediator.getDownloadManager().conflicts(guiDownloaderFactory.getURN(), (int)guiDownloaderFactory.getFileSize(), guiDownloaderFactory.getSaveFile())) {
            DownloaderUtils.showIsAlreadyDownloadingWarning(guiDownloaderFactory);
            return true;
        }
        return false;
    }

    public static void showIsAlreadyDownloadingWarning(GuiDownloaderFactory guiDownloaderFactory) {
        GUIMediator.showError(I18n.tr("You are already downloading this file to \"{0}\".", guiDownloaderFactory.getSaveFile()), QuestionsHandler.ALREADY_DOWNLOADING);
    }

    public static FileDesc getFromLibrary(URN uRN) {
        if (uRN == null) {
            return null;
        }
        FileDesc fileDesc = GuiCoreMediator.getFileManager().getFileDescForUrn(uRN);
        return fileDesc instanceof IncompleteFileDesc ? null : fileDesc;
    }

    public static boolean continueWithOrWithoutHashConflict(GuiDownloaderFactory guiDownloaderFactory) {
        FileDesc fileDesc = DownloaderUtils.getFromLibrary(guiDownloaderFactory.getURN());
        if (fileDesc != null) {
            return DownloaderUtils.showHashConflict(fileDesc);
        }
        return true;
    }

    private static boolean showHashConflict(FileDesc fileDesc) {
        String string = MessageFormat.format(I18n.tr("You already have the exact same file at {0}"), fileDesc.getFile());
        String string2 = I18n.tr("Do you want to continue downloading anyway?");
        String string3 = I18n.tr("Continue");
        String[] stringArray = new String[]{string, string2};
        JOptionPane jOptionPane = new JOptionPane(stringArray, 3, 0, null, new String[]{string3, I18n.tr("Cancel")});
        JDialog jDialog = jOptionPane.createDialog(MessageService.getParentComponent(), I18n.tr("Same File Already In Library"));
        jDialog.setVisible(true);
        return string3.equals(jOptionPane.getValue());
    }

    public static File showFileChooser(GuiDownloaderFactory guiDownloaderFactory, Component component) {
        return FileChooserHandler.getSaveAsFile(component, I18nMarker.marktr("Save Download As"), guiDownloaderFactory.getSaveFile());
    }

    private static boolean isSaveLocationTaken(GuiDownloaderFactory guiDownloaderFactory) {
        return guiDownloaderFactory.getSaveFile().exists() || GuiCoreMediator.getDownloadManager().isSaveLocationTaken(guiDownloaderFactory.getSaveFile());
    }
}

