/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dock;

import com.limegroup.gnutella.util.MacOSXUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.limewire.service.ErrorService;
import org.limewire.util.OSUtils;

public class Dock {
    private static final boolean HAS_DOCK;
    public static final int ICON_WIDTH = 128;
    public static final int ICON_HEIGHT = 128;

    private Dock() {
    }

    public static Object getDockLock() {
        return Dock.class;
    }

    public static synchronized void setDockTileImage(Icon icon) {
        Dock.paintIcon(icon, false);
    }

    public static synchronized void setDockTileOverlayImage(Icon icon) {
        Dock.paintIcon(icon, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void paintIcon(Icon icon, boolean bl) {
        if (!HAS_DOCK) {
            return;
        }
        if (icon == null) {
            throw new NullPointerException("Icon is null");
        }
        int[] nArray = new int[16384];
        BufferedImage bufferedImage = new BufferedImage(128, 128, 2);
        JPanel jPanel = new JPanel();
        Dimension dimension = new Dimension(128, 128);
        jPanel.setSize(dimension);
        ((Component)jPanel).setPreferredSize(dimension);
        ((Component)jPanel).setMinimumSize(dimension);
        ((Component)jPanel).setMaximumSize(dimension);
        bufferedImage.setRGB(0, 0, 128, 128, nArray, 0, 128);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            icon.paintIcon(jPanel, graphics2D, 0, 0);
        }
        finally {
            graphics2D.dispose();
        }
        bufferedImage.getRGB(0, 0, 128, 128, nArray, 0, 128);
        Dock.DrawDockTileImage(nArray, bl, MacOSXUtils.getAppDir());
    }

    public static synchronized void restoreDockTileImage() {
        if (HAS_DOCK) {
            Dock.RestoreApplicationDockTileImage(MacOSXUtils.getAppDir());
        }
    }

    public static synchronized int requestUserAttention(AttentionType attentionType) {
        if (HAS_DOCK) {
            return Dock.RequestUserAttention(attentionType.type);
        }
        return -1;
    }

    public static synchronized void cancelUserAttentionRequest(int n) {
        if (HAS_DOCK) {
            Dock.CancelUserAttentionRequest(n);
        }
    }

    private static final native void DrawDockTileImage(int[] var0, boolean var1, String var2);

    private static final native void RestoreApplicationDockTileImage(String var0);

    private static final native int RequestUserAttention(int var0);

    private static final native void CancelUserAttentionRequest(int var0);

    static {
        boolean bl = false;
        if (OSUtils.isAnyMac()) {
            try {
                System.loadLibrary("Dock");
                bl = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                ErrorService.error(unsatisfiedLinkError);
            }
        }
        HAS_DOCK = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AttentionType {
        CRITICAL(0),
        INFORMATIONAL(10);

        private final int type;

        private AttentionType(int n2) {
            this.type = n2;
        }
    }
}

