/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.IconManager;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JLabel;

class TransferVisualizer {
    private static final CellRendererPane PANE = new CellRendererPane();
    private static final int IMAGE_WIDTH = 300;
    private static final int IMAGE_ROW_HEIGHT = 16;
    private final Transferable t;

    TransferVisualizer(Transferable transferable) {
        this.t = transferable;
    }

    Image getImage() {
        if (!this.t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return null;
        }
        List list = null;
        try {
            list = (List)this.t.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        int n = 16 * list.size();
        BufferedImage bufferedImage = new BufferedImage(300, n, 2);
        Graphics graphics = bufferedImage.getGraphics();
        JLabel jLabel = new JLabel();
        jLabel.setVerticalAlignment(1);
        jLabel.setOpaque(false);
        int n2 = 0;
        for (File file : list) {
            Icon icon = IconManager.instance().getIconForFile(file);
            jLabel.setIcon(icon);
            jLabel.setText(file.getName());
            PANE.paintComponent(graphics, jLabel, null, 0, n2, 300, n - n2);
            n2 += 16;
        }
        graphics.dispose();
        return bufferedImage;
    }
}

