/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.CheckBoxListPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import com.limegroup.gnutella.gui.library.RecursiveSharingDialog;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import com.limegroup.gnutella.settings.QuestionsHandler;
import java.awt.Frame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedFilesTransferHandler
extends LimeTransferHandler {
    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray, DropInfo dropInfo) {
        return this.canImport(jComponent, dataFlavorArray);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return !DNDUtils.containsLibraryFlavors(dataFlavorArray) && DNDUtils.containsFileFlavors(dataFlavorArray);
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable, DropInfo dropInfo) {
        return this.importData(jComponent, transferable);
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (!this.canImport(jComponent, transferable.getTransferDataFlavors())) {
            return false;
        }
        try {
            File[] fileArray = DNDUtils.getFiles(transferable);
            if (fileArray.length > 0) {
                return SharedFilesTransferHandler.handleFiles(fileArray);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean handleFiles(File[] fileArray) {
        List<File> list = SharedFilesTransferHandler.filterOutSharedFiles(fileArray);
        if (list.size() == 0) {
            return false;
        }
        CheckBoxListPanel<File> checkBoxListPanel = new CheckBoxListPanel<File>(list, new FileTextProvider(), false);
        checkBoxListPanel.getList().setVisibleRowCount(5);
        Object[] objectArray = new Object[]{new MultiLineLabel(I18n.tr("You dropped the following files/folders on LimeWire, please select the ones you would like to share."), 400), Box.createVerticalStrut(6), checkBoxListPanel, Box.createVerticalStrut(6), new MultiLineLabel(I18n.tr("All folders you select will also have their subfolders shared."), 400)};
        int n = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), objectArray, I18n.tr("Share Dropped Files?"), 2);
        if (n != 0) {
            return false;
        }
        List<File> list2 = checkBoxListPanel.getSelectedElements();
        if (list2.size() == 0) {
            if (QuestionsHandler.HIDE_EMPTY_DROPPED_SHARE_DIALOG.getValue()) {
                return false;
            }
            Object[] objectArray2 = new Object[]{I18n.tr("Yes, Try Again"), I18n.tr("No, Share Nothing")};
            JCheckBox jCheckBox = new JCheckBox(I18n.tr("Do not show this message again."));
            Object[] objectArray3 = new Object[]{new MultiLineLabel(I18n.tr("You clicked OK but did not select any files to be shared. Would you like to try again?"), 400), Box.createVerticalStrut(6), jCheckBox};
            n = JOptionPane.showOptionDialog(MessageService.getParentComponent(), objectArray3, I18n.tr("Warning"), -1, 1, null, objectArray2, objectArray2[0]);
            QuestionsHandler.HIDE_EMPTY_DROPPED_SHARE_DIALOG.setValue(jCheckBox.isSelected());
            if (n == 0) {
                return SharedFilesTransferHandler.handleFiles(fileArray);
            }
            return false;
        }
        HashSet<File> hashSet = new HashSet<File>();
        final HashSet<File> hashSet2 = new HashSet<File>();
        final FileManager fileManager = GuiCoreMediator.getFileManager();
        Object object = list2.iterator();
        while (object.hasNext()) {
            File file = object.next();
            if (file.isDirectory()) {
                if (!fileManager.isFolderShareable(file, true)) continue;
                hashSet.add(file);
                continue;
            }
            if (!file.exists()) continue;
            hashSet2.add(file);
        }
        if (!hashSet.isEmpty() && ((RecursiveSharingDialog)(object = new RecursiveSharingDialog((Frame)GUIMediator.getAppFrame(), hashSet.toArray(new File[0])))).showChooseDialog(MessageService.getParentComponent()) == RecursiveSharingDialog.State.OK) {
            BackgroundExecutorService.schedule(new Runnable((RecursiveSharingDialog)object){
                final /* synthetic */ RecursiveSharingDialog val$dialog;
                {
                    this.val$dialog = recursiveSharingDialog;
                }

                public void run() {
                    fileManager.addSharedFolders(this.val$dialog.getRootsToShare(), this.val$dialog.getFoldersToExclude());
                }
            });
        }
        BackgroundExecutorService.schedule(new Runnable(){

            public void run() {
                for (File file : hashSet2) {
                    fileManager.addFileAlways(file);
                }
            }
        });
        GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
        return true;
    }

    private static List<File> filterOutSharedFiles(File[] fileArray) {
        FileManager fileManager = GuiCoreMediator.getFileManager();
        ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
        for (File file : fileArray) {
            if (fileManager.isFileShared(file) || fileManager.isFolderShared(file)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileTextProvider
    implements CheckBoxList.TextProvider<File> {
        private FileTextProvider() {
        }

        @Override
        public String getText(File file) {
            return file.getName();
        }

        @Override
        public String getToolTipText(File file) {
            return file.getAbsolutePath();
        }

        @Override
        public Icon getIcon(File file) {
            Icon icon = IconManager.instance().getIconForFile(file);
            return icon != null ? icon : new GUIUtils.EmptyIcon("", 16, 16);
        }
    }
}

