/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.util.BackgroundExecutorService;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import org.limewire.i18n.I18nMarker;

public class ShareFileSpeciallyAction
extends AbstractAction {
    public ShareFileSpeciallyAction() {
        this.putValue("Name", I18n.tr("Share New File..."));
        this.putValue("ShortDescription", "Opens a Dialog and Lets You Choose a File to Share");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final List<File> list = FileChooserHandler.getMultiInputFile(MessageService.getParentComponent(), I18nMarker.marktr("Share New File..."), I18nMarker.marktr("Share"), null);
        if (list != null) {
            BackgroundExecutorService.schedule(new Runnable(){

                public void run() {
                    for (File file : list) {
                        GuiCoreMediator.getFileManager().addFileAlways(file, new Listener());
                    }
                }
            });
        }
    }

    private static class Listener
    implements FileEventListener {
        private Listener() {
        }

        public void handleFileEvent(final FileManagerEvent fileManagerEvent) {
            GUIMediator.safeInvokeLater(new Runnable(){

                public void run() {
                    if (fileManagerEvent.isAlreadySharedEvent()) {
                        GUIMediator.showError(I18n.tr("The file \"{0}\" is already shared.", fileManagerEvent.getFiles()[0]));
                    } else if (!fileManagerEvent.isAddEvent() && !fileManagerEvent.isAddStoreEvent()) {
                        GUIMediator.showError(I18n.tr("FrostWire was unable to share the file \"{0}\".", fileManagerEvent.getFiles()[0]));
                    }
                }
            });
        }
    }
}

