/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import org.limewire.i18n.I18nMarker;

public class SearchAction
extends AbstractAction {
    private SearchInformation info;

    public SearchAction(String string) {
        this(SearchInformation.createKeywordSearch(string, null, MediaType.getAnyTypeMediaType()), I18nMarker.marktr("Search for Keywords: {0}"));
    }

    public SearchAction(SearchInformation searchInformation) {
        this(searchInformation, I18nMarker.marktr("Search for: {0}"));
    }

    public SearchAction(SearchInformation searchInformation, String string) {
        this.info = searchInformation;
        this.putValue("Name", MessageFormat.format(I18n.tr(string), searchInformation.getTitle()));
        if (SearchMediator.validateInfo(searchInformation) != 0) {
            throw new IllegalArgumentException("invalid search info: " + searchInformation);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SearchMediator.triggerSearch(this.info);
        GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
    }
}

