/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.banner.Ad;
import com.limegroup.gnutella.gui.banner.Banner;
import com.limegroup.gnutella.settings.UpdateSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import javax.swing.JLabel;
import javax.swing.Timer;
import javax.swing.plaf.metal.MetalLabelUI;
import org.limewire.i18n.I18nMarker;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;

final class StatusLinkHandler
implements SettingListener {
    private static final Banner DEFAULT_BANNER = new Banner(I18nMarker.marktr("For Turbo-Charged searches get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&21", "0.111111", I18nMarker.marktr("Support LimeWire's peer-to-peer development. Get PRO."), "http://www.limewire.com/index.jsp/pro&22", "0.111111", I18nMarker.marktr("Purchase LimeWire PRO to help us make downloads faster."), "http://www.limewire.com/index.jsp/pro&23", "0.111111", I18nMarker.marktr("For Turbo-Charged downloads get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&24", "0.111111", I18nMarker.marktr("Support open networks. Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&25", "0.111111", I18nMarker.marktr("Support open source and open protocols. Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&26", "0.111111", I18nMarker.marktr("For Turbo-Charged performance get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&27", "0.111111", I18nMarker.marktr("Keep the Internet open. Get LimeWire PRO."), "http://www.limewire.com/index.jsp/pro&28", "0.111111", I18nMarker.marktr("Developing LimeWire costs real money. Get PRO."), "http://www.limewire.com/index.jsp/pro&29", "0.111111");
    private Banner ads;
    private final Map<Ad, LabelURLPair> labels = Collections.synchronizedMap(new HashMap());
    private LabelURLPair _curLabel;
    private final JLabel LABEL = new JLabel("", 0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatusLinkHandler() {
        if (GUIMediator.isEnglishLocale()) {
            this.loadLabels();
            UpdateSettings.PRO_ADS.addSettingListener(this);
        }
        Object object = this.labels;
        synchronized (object) {
            if (this.labels.isEmpty()) {
                this.updateLabels(DEFAULT_BANNER);
            }
            assert (!this.labels.isEmpty()) : "couldn't load any pro banner!";
        }
        this.LABEL.setUI(new LinkLabelUI());
        object = this.LABEL.getFontMetrics(this.LABEL.getFont());
        int n = ((FontMetrics)object).stringWidth("123456789/123456789/1");
        Object object2 = this.labels;
        synchronized (object2) {
            for (LabelURLPair labelURLPair : this.labels.values()) {
                n = Math.max(n, ((FontMetrics)object).stringWidth(labelURLPair.getLabel()));
            }
        }
        object2 = new Dimension(n, ((FontMetrics)object).getHeight());
        this.LABEL.setForeground(Color.blue);
        this.LABEL.setPreferredSize((Dimension)object2);
        this.LABEL.setMaximumSize((Dimension)object2);
        this.LABEL.setText(this.getNextLabelURLPair().getLabel());
        this.LABEL.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                StatusLinkHandler.this.handleLinkClick();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }

            public void mouseExited(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        });
        if (this.labels.size() > 1) {
            new Timer(30000, new LabelTimerListener()).start();
        }
    }

    public void settingChanged(SettingEvent settingEvent) {
        if (settingEvent.getEventType() != SettingEvent.EventType.VALUE_CHANGED) {
            return;
        }
        this.loadLabels();
    }

    private void loadLabels() {
        try {
            Banner banner = new Banner(UpdateSettings.PRO_ADS.getValue());
            this.updateLabels(banner);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLabels(Banner banner) {
        Map<Ad, LabelURLPair> map = this.labels;
        synchronized (map) {
            this.ads = banner;
            this.labels.clear();
            for (Ad ad : this.ads.getAllAds()) {
                String string = ad.getText();
                if (string.contains("_") && string.toUpperCase().equals(string)) {
                    try {
                        string = I18n.tr(string);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
                this.labels.put(ad, new LabelURLPair(string, ad.getURI()));
            }
        }
    }

    Component getComponent() {
        return this.LABEL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LabelURLPair getNextLabelURLPair() {
        Map<Ad, LabelURLPair> map = this.labels;
        synchronized (map) {
            this._curLabel = this.labels.get(this.ads.getAd());
        }
        return this._curLabel;
    }

    private void handleLinkChange() {
        String string = this.getNextLabelURLPair().getLabel();
        this.LABEL.setText(string);
        FontMetrics fontMetrics = this.LABEL.getFontMetrics(this.LABEL.getFont());
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        Dimension dimension = new Dimension(n, n2);
        this.LABEL.setPreferredSize(dimension);
        GUIMediator.instance().getStatusLine().refresh();
    }

    private void handleLinkClick() {
        GUIMediator.openURL(this._curLabel.getURL());
    }

    private class LinkLabelUI
    extends MetalLabelUI {
        private LinkLabelUI() {
        }

        protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
            super.paintEnabledText(jLabel, graphics, string, n, n2);
            if (StatusLinkHandler.this.LABEL.getText() == null) {
                return;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.fillRect(n, fontMetrics.getAscent() + 2, fontMetrics.stringWidth(StatusLinkHandler.this.LABEL.getText()) - ((StatusLinkHandler)StatusLinkHandler.this).LABEL.getInsets().right, 1);
        }
    }

    private static final class LabelURLPair {
        private final String LABEL_STRING;
        private final String URL;

        private LabelURLPair(String string, String string2) {
            this.LABEL_STRING = string;
            this.URL = string2;
        }

        private String getLabel() {
            return this.LABEL_STRING;
        }

        private String getURL() {
            return this.URL;
        }
    }

    private class LabelTimerListener
    implements ActionListener {
        private LabelTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StatusLinkHandler.this.handleLinkChange();
        }
    }
}

