/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LimeJProgressBar;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.NumberFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.limewire.util.OSUtils;

public class StatusComponent
extends JPanel {
    private final JProgressBar BAR;
    private final JLabel LABEL;
    private final boolean STEPPING;
    private final NumberFormat NF;

    public StatusComponent() {
        this.STEPPING = false;
        this.NF = null;
        this.LABEL = new JLabel();
        this.BAR = new LimeJProgressBar();
        this.setLayout(new BoxLayout(this, 1));
        this.construct();
        GUIUtils.setOpaque(false, this);
        if (this.BAR != null && !OSUtils.isMacOSX()) {
            this.BAR.setOpaque(true);
        }
        if (this.LABEL != null) {
            this.LABEL.setForeground(ThemeFileHandler.WINDOW4_COLOR.getValue());
        }
        this.BAR.setIndeterminate(true);
    }

    public StatusComponent(int n) {
        this.STEPPING = true;
        this.LABEL = new JLabel();
        this.LABEL.setFont(this.LABEL.getFont().deriveFont(1));
        this.BAR = new LimeJProgressBar();
        Dimension dimension = this.BAR.getPreferredSize();
        this.BAR.setPreferredSize(new Dimension(dimension.width, 13));
        GUIUtils.restrictSize(this.BAR, GUIUtils.SizePolicy.RESTRICT_HEIGHT);
        this.NF = NumberFormat.getInstance(GUIMediator.getLocale());
        this.NF.setMaximumIntegerDigits(3);
        this.NF.setMaximumFractionDigits(0);
        this.setLayout(new BoxLayout(this, 1));
        this.construct();
        GUIUtils.setOpaque(false, this);
        if (this.LABEL != null) {
            this.LABEL.setForeground(ThemeFileHandler.WINDOW4_COLOR.getValue());
        }
        this.BAR.setMaximum(n + 1);
        this.BAR.setMinimum(0);
        this.BAR.setValue(0);
    }

    public void setProgressPreferredSize(Dimension dimension) {
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        if (this.BAR != null) {
            this.BAR.setMinimumSize(dimension);
            this.BAR.setMaximumSize(dimension);
            this.BAR.setPreferredSize(dimension);
        }
    }

    public void setText(String string) {
        if (this.STEPPING) {
            this.BAR.setValue(this.BAR.getValue() + 1);
            String string2 = this.NF.format((double)this.BAR.getValue() / (double)this.BAR.getMaximum() * 100.0);
            string = string2 + "% (" + string + ")";
        }
        if (this.STEPPING || OSUtils.isMacOSX()) {
            this.LABEL.setText(string);
        } else {
            this.BAR.setString(string);
        }
    }

    private void construct() {
        if (this.STEPPING || OSUtils.isMacOSX()) {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.LABEL, "South");
            this.add(jPanel);
            this.add(Box.createVerticalStrut(9));
        } else {
            this.BAR.setStringPainted(true);
        }
        this.add(this.BAR);
    }
}

