/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.InputFieldDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.limewire.i18n.I18nMarker;

public final class StandardListEditor {
    private final JPanel MAIN_PANEL = new JPanel(new GridBagLayout());
    private final JList LIST = new JList();
    private final JButton REMOVE_BUTTON;
    private final JButton ADD_BUTTON;
    private AddAction _addAction;
    private RemoveAction _removeAction;
    private ActionListener _addListener = null;
    private boolean _listChanged = false;

    public StandardListEditor(String string) {
        this(I18nMarker.marktr("Add..."), I18nMarker.marktr("Remove"), string);
    }

    public StandardListEditor(ActionListener actionListener) {
        this(I18nMarker.marktr("Add..."), I18nMarker.marktr("Remove"), "");
        this.setAddActionListener(actionListener);
    }

    public StandardListEditor(String string, String string2, String string3) {
        this._addAction = new AddAction(string, string3);
        this._removeAction = new RemoveAction(string2);
        GUIUtils.bindKeyToAction(this.LIST, KeyStroke.getKeyStroke(127, 0), this._removeAction);
        this.LIST.setSelectionMode(0);
        this.LIST.addListSelectionListener(new ListEditorSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.LIST);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.MAIN_PANEL.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 6, 0);
        this.ADD_BUTTON = new JButton(this._addAction);
        this.MAIN_PANEL.add((Component)this.ADD_BUTTON, gridBagConstraints);
        this.REMOVE_BUTTON = new JButton(this._removeAction);
        this.REMOVE_BUTTON.setEnabled(false);
        this.MAIN_PANEL.add((Component)this.REMOVE_BUTTON, gridBagConstraints);
    }

    public Component getComponent() {
        return this.MAIN_PANEL;
    }

    private void addElement(Object object) {
        DefaultListModel defaultListModel = (DefaultListModel)this.LIST.getModel();
        defaultListModel.addElement(object);
    }

    public void addFile(File file) {
        this.addElement(file);
    }

    public void addString(String string) {
        this.addElement(string);
    }

    public void setListData(Vector vector) {
        DefaultListModel defaultListModel = new DefaultListModel();
        for (int i = 0; i < vector.size(); ++i) {
            defaultListModel.addElement(vector.get(i));
        }
        this.LIST.setModel(defaultListModel);
    }

    private void setListDataObjects(Object[] objectArray) {
        DefaultListModel<Object> defaultListModel = new DefaultListModel<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultListModel.addElement(objectArray[i]);
        }
        this.LIST.setModel(defaultListModel);
    }

    public void setListData(File[] fileArray) {
        this.setListDataObjects(fileArray);
    }

    public void setListData(String[] stringArray) {
        this.setListDataObjects(stringArray);
    }

    public void clearSelection() {
        this.LIST.clearSelection();
    }

    public String[] getDataAsStringArray() {
        DefaultListModel defaultListModel = (DefaultListModel)this.LIST.getModel();
        Object[] objectArray = defaultListModel.toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }

    public File[] getDataAsFileArray() {
        DefaultListModel defaultListModel = (DefaultListModel)this.LIST.getModel();
        Object[] objectArray = defaultListModel.toArray();
        File[] fileArray = new File[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            fileArray[i] = (File)objectArray[i];
        }
        return fileArray;
    }

    public Object[] getDataAsObjectArray() {
        DefaultListModel defaultListModel = (DefaultListModel)this.LIST.getModel();
        return defaultListModel.toArray();
    }

    private void setAddActionListener(ActionListener actionListener) {
        this._addListener = actionListener;
    }

    public boolean getListChanged() {
        return this._listChanged;
    }

    public void resetList() {
        this._listChanged = false;
    }

    private class ListEditorSelectionListener
    implements ListSelectionListener {
        private ListEditorSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                StandardListEditor.this.REMOVE_BUTTON.setEnabled(false);
            } else {
                StandardListEditor.this.REMOVE_BUTTON.setEnabled(true);
            }
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public RemoveAction(String string) {
            this.putValue("Name", I18n.tr(string));
            this.putValue("ShortDescription", I18n.tr("Remove Selected Item"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StandardListEditor.this._listChanged = true;
            if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                return;
            }
            DefaultListModel defaultListModel = (DefaultListModel)StandardListEditor.this.LIST.getModel();
            defaultListModel.remove(StandardListEditor.this.LIST.getSelectedIndex());
            if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                StandardListEditor.this.REMOVE_BUTTON.setEnabled(false);
            }
        }
    }

    private class AddAction
    extends AbstractAction {
        private final String INPUT_FIELD_KEY;

        public AddAction(String string, String string2) {
            this.putValue("Name", I18n.tr(string));
            this.putValue("ShortDescription", I18n.tr("Add New List Item"));
            this.INPUT_FIELD_KEY = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (StandardListEditor.this._addListener != null) {
                StandardListEditor.this._addListener.actionPerformed(actionEvent);
            } else {
                InputFieldDialog inputFieldDialog = new InputFieldDialog(this.INPUT_FIELD_KEY);
                int n = inputFieldDialog.showDialog();
                if (n == 79) {
                    StandardListEditor.this._listChanged = true;
                    StandardListEditor.this.addElement(inputFieldDialog.getText());
                }
            }
        }
    }
}

