/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.notify.Notification;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.util.LimeWireUtils;

public class SettingsWarningManager {
    public static void checkTemporaryDirectoryUsage() {
        if (LimeWireUtils.isTemporaryDirectoryInUse()) {
            NotifyUserProxy.instance().showMessage(new Notification(I18n.tr("FrostWire was unable to create your settings folder and is using a temporary folder.  Your settings may be deleted when you close FrostWire. ")));
        }
    }

    public static void checkSettingsLoadSaveFailure() {
        String string = null;
        if (LimeWireUtils.hasSettingsLoadSaveFailures()) {
            string = I18n.tr("FrostWire has encountered problems in managing your settings.  Your settings changes may not be saved on shutdown.");
            LimeWireUtils.resetSettingsLoadSaveFailures();
        } else if (ResourceManager.hasLoadFailure()) {
            string = I18n.tr("FrostWire has encountered problems in loading your settings.  FrostWire will attempt to use the default values; however, may behave unexpectedly.");
            ResourceManager.resetLoadFailure();
        }
        if (string != null) {
            NotifyUserProxy.instance().showMessage(new Notification(string));
        }
    }
}

