/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.LimeJProgressBar;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public final class ProgTabUIFactory {
    private static final Class aquaUI = ProgTabUIFactory.loadClass("apple.laf.AquaTabbedPaneUI");
    private static final Class windowsUI = ProgTabUIFactory.loadClass("com.sun.java.swing.plaf.windows.WindowsTabbedPaneUI");
    private static final Class metalUI = MetalTabbedPaneUI.class;
    private static final Class basicUI = BasicTabbedPaneUI.class;

    private ProgTabUIFactory() {
    }

    private static final Class loadClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static TabbedPaneUI createNewUI(String string, TabbedPaneUI tabbedPaneUI) {
        Class clazz = ProgTabUIFactory.loadClass(string);
        if (clazz == null) {
            return tabbedPaneUI;
        }
        try {
            return (TabbedPaneUI)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            return tabbedPaneUI;
        }
        catch (InstantiationException instantiationException) {
            return tabbedPaneUI;
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            return tabbedPaneUI;
        }
        catch (SecurityException securityException) {
            return tabbedPaneUI;
        }
        catch (ClassCastException classCastException) {
            return tabbedPaneUI;
        }
    }

    public static void extendUI(JTabbedPane jTabbedPane) {
        TabbedPaneUI tabbedPaneUI;
        TabbedPaneUI tabbedPaneUI2 = tabbedPaneUI = jTabbedPane.getUI();
        if (aquaUI != null && aquaUI.isInstance(tabbedPaneUI)) {
            tabbedPaneUI2 = ProgTabUIFactory.createNewUI("com.limegroup.gnutella.gui.AquaTab", tabbedPaneUI2);
        } else if (windowsUI != null && windowsUI.isInstance(tabbedPaneUI)) {
            tabbedPaneUI2 = ProgTabUIFactory.createNewUI("com.limegroup.gnutella.gui.WinTab", tabbedPaneUI2);
        } else if (metalUI != null && metalUI.isInstance(tabbedPaneUI)) {
            tabbedPaneUI2 = new MetalTab();
        } else if (tabbedPaneUI.getClass() == basicUI) {
            tabbedPaneUI2 = new BasicTab();
        }
        jTabbedPane.setUI(tabbedPaneUI2);
    }

    public static interface Progressor {
        public double calculatePercentage(long var1);
    }

    private static class MetalTab
    extends MetalTabbedPaneUI {
        private final JProgressBar PROGRESS = new LimeJProgressBar();
        private final CellRendererPane PANE = new CellRendererPane();

        public MetalTab() {
            this.PROGRESS.setMinimum(0);
            this.PROGRESS.setMaximum(100);
            this.PROGRESS.setBorderPainted(false);
            this.PROGRESS.setOpaque(false);
        }

        protected void paintText(Graphics graphics, int n, Font font, FontMetrics fontMetrics, int n2, String string, Rectangle rectangle, boolean bl) {
            long l = System.currentTimeMillis();
            Progressor progressor = (Progressor)((Object)this.tabPane.getComponentAt(n2));
            double d = progressor.calculatePercentage(l);
            if (d > 1.0) {
                d = 1.0;
            }
            this.PROGRESS.setValue((int)(d * 100.0));
            Rectangle rectangle2 = this.tabPane.getBoundsAt(n2);
            int n3 = rectangle.x - 4;
            int n4 = rectangle.y;
            int n5 = rectangle2.width + rectangle2.x - n3 - 1;
            int n6 = rectangle2.height + rectangle2.y - n4;
            this.PANE.paintComponent(graphics, this.PROGRESS, this.tabPane.getParent(), n3, n4, n5, n6);
            super.paintText(graphics, n, font, fontMetrics, n2, string, rectangle, bl);
        }
    }

    private static class BasicTab
    extends BasicTabbedPaneUI {
        private BasicTab() {
        }

        protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
            Color color = this.tabPane.getBackgroundAt(n2).darker();
            graphics.setColor(color);
            long l = System.currentTimeMillis();
            Progressor progressor = (Progressor)((Object)this.tabPane.getComponentAt(n2));
            double d = progressor.calculatePercentage(l);
            if (d > 1.0) {
                d = 1.0;
            }
            graphics.fillRect(n3 + 1, n4 + 1, (int)((double)(n5 - 3) * d), n6 - 1);
        }
    }
}

