/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.I18n;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.limewire.i18n.I18nMarker;

public class LimeTextField
extends JTextField {
    private static Action UNDO_ACTION = new FieldAction(I18nMarker.marktr("Undo")){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getField(actionEvent).undo();
        }
    };
    private static Action CUT_ACTION = new FieldAction(I18nMarker.marktr("Cut")){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getField(actionEvent).cut();
        }
    };
    private static Action COPY_ACTION = new FieldAction(I18nMarker.marktr("Copy")){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getField(actionEvent).copy();
        }
    };
    private static Action PASTE_ACTION = new FieldAction(I18nMarker.marktr("Paste")){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getField(actionEvent).paste();
        }
    };
    private static Action DELETE_ACTION = new FieldAction(I18nMarker.marktr("Delete")){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getField(actionEvent).replaceSelection("");
        }
    };
    private static Action SELECT_ALL_ACTION = new FieldAction(I18nMarker.marktr("Select All")){

        public void actionPerformed(ActionEvent actionEvent) {
            this.getField(actionEvent).selectAll();
        }
    };
    private static final JPopupMenu POPUP = LimeTextField.createPopup();
    private UndoManager undoManager;

    public LimeTextField() {
        this.init();
    }

    public LimeTextField(String string) {
        super(string);
        this.init();
    }

    public LimeTextField(int n) {
        super(n);
        this.init();
    }

    public LimeTextField(String string, int n) {
        super(string, n);
        this.init();
    }

    public LimeTextField(Document document, String string, int n) {
        super(document, string, n);
        this.init();
    }

    public void undo() {
        try {
            if (this.undoManager != null) {
                this.undoManager.undoOrRedo();
            }
        }
        catch (CannotUndoException cannotUndoException) {
        }
        catch (CannotRedoException cannotRedoException) {
            // empty catch block
        }
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setDocument(Document document) {
        if (document != this.getDocument()) {
            this.undoManager = null;
        }
        super.setDocument(document);
    }

    private void init() {
        this.setComponentPopupMenu(POPUP);
        this.undoManager = new UndoManager();
        this.undoManager.setLimit(1);
        this.getDocument().addUndoableEditListener(this.undoManager);
    }

    private static JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu(){

            public void show(Component component, int n, int n2) {
                ((LimeTextField)component).updateActions();
                super.show(component, n, n2);
            }
        };
        jPopupMenu.add(new JMenuItem(UNDO_ACTION));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(CUT_ACTION));
        jPopupMenu.add(new JMenuItem(COPY_ACTION));
        jPopupMenu.add(new JMenuItem(PASTE_ACTION));
        jPopupMenu.add(new JMenuItem(DELETE_ACTION));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem(SELECT_ALL_ACTION));
        return jPopupMenu;
    }

    private void updateActions() {
        String string = this.getSelectedText();
        if (string == null) {
            string = "";
        }
        boolean bl = !string.equals("");
        boolean bl2 = string.equals(this.getText());
        UNDO_ACTION.setEnabled(this.isEnabled() && this.isEditable() && this.isUndoAvailable());
        CUT_ACTION.setEnabled(this.isEnabled() && this.isEditable() && bl);
        COPY_ACTION.setEnabled(this.isEnabled() && bl);
        PASTE_ACTION.setEnabled(this.isEnabled() && this.isEditable() && this.isPasteAvailable());
        DELETE_ACTION.setEnabled(this.isEnabled() && bl);
        SELECT_ALL_ACTION.setEnabled(this.isEnabled() && !bl2);
    }

    private boolean isUndoAvailable() {
        return this.getUndoManager() != null && this.getUndoManager().canUndoOrRedo();
    }

    private boolean isPasteAvailable() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            return clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private static abstract class FieldAction
    extends AbstractAction {
        public FieldAction(String string) {
            super(I18n.tr(string));
        }

        protected LimeTextField getField(ActionEvent actionEvent) {
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            JPopupMenu jPopupMenu = (JPopupMenu)jMenuItem.getParent();
            return (LimeTextField)jPopupMenu.getInvoker();
        }
    }
}

