/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.LimeWireUtils;
import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageUtils {
    private static Log LOG = LogFactory.getLog(LanguageUtils.class);
    private static final String BUNDLE_PREFIX = "org/limewire/i18n/Messages_";
    private static final String BUNDLE_POSTFIX = ".class";
    private static final String BUNDLE_MARKER = "org/limewire/i18n/Messages.class";
    private static final String CVS_BUNDLE_FILE = "../lib/jars/compile/messages.jar";

    public static void setLocale(Locale locale) {
        ApplicationSettings.LANGUAGE.setValue(locale.getLanguage());
        ApplicationSettings.COUNTRY.setValue(locale.getCountry());
        ApplicationSettings.LOCALE_VARIANT.setValue(locale.getVariant());
        GUIMediator.resetLocale();
    }

    public static Locale[] getLocales(Font font) {
        LinkedList<Locale> linkedList = new LinkedList<Locale>();
        File file = FileUtils.getJarFromClasspath(LanguageUtils.class.getClassLoader(), BUNDLE_MARKER);
        if (file != null) {
            LanguageUtils.addLocalesFromJar(linkedList, file);
        } else {
            LOG.warn("Could not find bundle jar to determine locales");
        }
        if (LimeWireUtils.isTestingVersion()) {
            LanguageUtils.addLocalesFromJar(linkedList, new File(CVS_BUNDLE_FILE));
        }
        Collections.sort(linkedList, new Comparator<Locale>(){

            @Override
            public int compare(Locale locale, Locale locale2) {
                return locale.getDisplayName(locale).compareToIgnoreCase(locale2.getDisplayName(locale2));
            }
        });
        linkedList.remove(Locale.ENGLISH);
        linkedList.add(0, Locale.ENGLISH);
        if (font != null && !OSUtils.isMacOSX()) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                if (GUIUtils.canDisplay(font, locale.getDisplayName(locale))) continue;
                iterator.remove();
            }
        }
        return linkedList.toArray(new Locale[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addLocalesFromJar(List<Locale> list, File file) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string;
                ArrayList<String> arrayList;
                String string2 = enumeration.nextElement().getName();
                if (!string2.startsWith(BUNDLE_PREFIX) || !string2.endsWith(BUNDLE_POSTFIX) || string2.indexOf("$") != -1 || (arrayList = new ArrayList<String>(Arrays.asList((string = string2.substring(BUNDLE_PREFIX.length(), string2.length() - BUNDLE_POSTFIX.length())).split("_", 3)))).size() < 1) continue;
                while (arrayList.size() < 3) {
                    arrayList.add("");
                }
                Locale locale = new Locale((String)arrayList.get(0), (String)arrayList.get(1), (String)arrayList.get(2));
                list.add(locale);
            }
        }
        catch (IOException iOException) {
            LOG.warn("Could not determine locales", iOException);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean isEnglishLocale(Locale locale) {
        return Locale.ENGLISH.getLanguage().equals(locale.getLanguage());
    }

    public static int getMatchScore(Locale locale, Locale locale2) {
        int n = 0;
        if (locale.getLanguage().equals(locale2.getLanguage())) {
            ++n;
        } else if (locale2.getLanguage().length() > 0) {
            return -1;
        }
        if (locale.getCountry().equals(locale2.getCountry())) {
            ++n;
        } else if (locale2.getCountry().length() > 0) {
            return -1;
        }
        if (locale.getVariant().equals(locale2.getVariant())) {
            ++n;
        } else if (locale2.getVariant().length() > 0) {
            return -1;
        }
        return n;
    }

    public static boolean matchesDefaultLocale(Locale locale) {
        Locale locale2 = Locale.getDefault();
        return LanguageUtils.matchesOrIsMoreSpecific(locale2.getLanguage(), locale.getLanguage()) && LanguageUtils.matchesOrIsMoreSpecific(locale2.getCountry(), locale.getCountry()) && LanguageUtils.matchesOrIsMoreSpecific(locale2.getVariant(), locale.getVariant());
    }

    private static boolean matchesOrIsMoreSpecific(String string, String string2) {
        return string2.length() == 0 || string.equals(string2);
    }
}

