/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.IllegalComponentStateException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.limewire.service.ErrorService;

public class DefaultErrorCatcher {
    static void install() {
        System.setProperty("sun.awt.exception.handler", DefaultErrorCatcher.class.getName());
    }

    public void handle(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        String string = stringWriter.toString();
        if (!this.isIgnorable(throwable, string)) {
            ErrorService.error(throwable, "Uncaught event-thread error.");
        } else {
            System.err.println("Ignoring error:");
            throwable.printStackTrace();
        }
    }

    private boolean isIgnorable(Throwable throwable, String string) {
        if (throwable instanceof StackOverflowError) {
            return true;
        }
        if (throwable instanceof OutOfMemoryError) {
            return true;
        }
        if (string == null) {
            return true;
        }
        if (string.indexOf("javax.swing.RepaintManager") != -1) {
            return true;
        }
        if (string.indexOf("sun.awt.RepaintArea.paint") != -1) {
            return true;
        }
        if (throwable instanceof ArrayIndexOutOfBoundsException) {
            if (string.indexOf("apple.awt.CWindow.displayChanged") != -1) {
                return true;
            }
            if (string.indexOf("javax.swing.plaf.basic.BasicTabbedPaneUI.getTabBounds") != -1) {
                return true;
            }
        }
        if (throwable instanceof IllegalStateException && string.indexOf("cannot open system clipboard") != -1) {
            return true;
        }
        if (throwable instanceof IllegalComponentStateException && string.indexOf("component must be showing on the screen to determine its location") != -1) {
            return true;
        }
        if (throwable instanceof NullPointerException) {
            if (string.indexOf("MetalFileChooserUI") != -1) {
                return true;
            }
            if (string.indexOf("WindowsFileChooserUI") != -1) {
                return true;
            }
            if (string.indexOf("AquaDirectoryModel") != -1) {
                return true;
            }
            if (string.indexOf("SizeRequirements.calculateAlignedPositions") != -1) {
                return true;
            }
            if (string.indexOf("BasicTextUI.damageRange") != -1) {
                return true;
            }
            if (string.indexOf("null pData") != -1) {
                return true;
            }
            if (string.indexOf("disposed component") != -1) {
                return true;
            }
            if (string.indexOf("javax.swing.JComponent.repaint") != -1 && string.indexOf("com.limegroup.gnutella.gui.FileChooserHandler.getSaveAsFile") != -1) {
                return true;
            }
            if (string.indexOf("javax.swing.JComponent.repaint") != -1 && string.indexOf("com.limegroup.gnutella.gui.FileChooserHandler.getInput") != -1) {
                return true;
            }
        }
        if (throwable instanceof IndexOutOfBoundsException) {
            if (string.indexOf("Invalid index") != -1 && string.indexOf("com.limegroup.gnutella.gui.FileChooserHandler.getSaveAsFile") != -1) {
                return true;
            }
            if (string.indexOf("Invalid index") != -1 && string.indexOf("com.limegroup.gnutella.gui.FileChooserHandler.getInput") != -1) {
                return true;
            }
        }
        if (throwable instanceof InternalError && string.indexOf("getGraphics not implemented for this component") != -1) {
            return true;
        }
        if (string.indexOf("com.limegroup.gnutella") == -1 && string.indexOf("org.limewire") == -1) {
            return true;
        }
        if (this.intercepts(string, "com.limegroup.gnutella.tables.MouseEventConsumptionChecker")) {
            return true;
        }
        return this.intercepts(string, "com.limegroup.gnutella.gui.tables.LimeJTable.processMouseEvent");
    }

    private boolean intercepts(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return false;
        }
        if (string.lastIndexOf("com.limegroup.gnutella", n) != -1 && string.lastIndexOf("org.limewire", n) != -1) {
            return false;
        }
        if ((n += string2.length()) >= string.length()) {
            return false;
        }
        return string.indexOf("com.limegroup.gnutella", n) == -1 || string.lastIndexOf("org.limewire", n) == -1;
    }
}

