/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.google.inject.Inject;
import com.limegroup.gnutella.bugs.LocalClientInfo;
import com.limegroup.gnutella.dht.DHTManager;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.themes.ThemeFileHandler;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.ConsoleSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggerRepository;
import org.limewire.i18n.I18nMarker;
import org.limewire.mojito.MojitoDHT;
import org.limewire.service.ErrorService;
import org.limewire.util.CommonUtils;

public class Console
extends JPanel
implements ThemeObserver {
    @Inject
    private static volatile LocalClientInfoFactory localClientInfoFactory;
    private final int idealSize = ConsoleSettings.CONSOLE_IDEAL_SIZE.getValue();
    private final int maxExcess = ConsoleSettings.CONSOLE_MAX_EXCESS.getValue();
    private JScrollPane scrollPane;
    private JTextArea output = new JTextArea();
    private JButton apply;
    private JButton clear;
    private JButton save;
    private JComboBox loggerComboBox;
    private JComboBox levelComboBox;
    private WholeNumberField delayTxt;
    private boolean scroll = true;
    private boolean altCtrlDown = false;
    private List<ConsoleListener> listeners = null;
    private int delay;
    private StringBuffer delayBuf;
    private Timer delayTimer;

    public Console() {
        this.output.setEditable(false);
        this.scrollPane = new JScrollPane(this.output);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (adjustmentEvent.getValueIsAdjusting()) {
                    Console.this.scroll = false;
                } else {
                    Console.this.scroll = true;
                }
            }
        });
        this.loggerComboBox = new JComboBox(new LoggerComboBoxModel());
        this.levelComboBox = new JComboBox(new LevelComboBoxModel());
        this.loggerComboBox.setAutoscrolls(true);
        this.loggerComboBox.setMaximumRowCount(20);
        this.loggerComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Console.this.selectLoggerLevel();
            }
        });
        this.loggerComboBox.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                Console.this.refreshLoggers();
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            }
        });
        this.levelComboBox.setAutoscrolls(true);
        this.apply = new JButton(I18n.tr("Apply"));
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.applyLevel();
            }
        });
        this.clear = new JButton(I18n.tr("Clear"));
        this.clear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.clear();
            }
        });
        this.save = new JButton(I18n.tr("Save"));
        this.save.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.save();
            }
        });
        JLabel jLabel = new JLabel(I18n.tr("Delay: "));
        jLabel.setMinimumSize(new Dimension(50, 23));
        jLabel.setHorizontalAlignment(4);
        this.delay = 0;
        this.delayBuf = new StringBuffer();
        this.delayTimer = null;
        this.delayTxt = new WholeNumberField(0, 3);
        this.delayTxt.setText("0");
        this.delayTxt.setHorizontalAlignment(4);
        this.delayTxt.setMinimumSize(new Dimension(50, 23));
        this.delayTxt.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Console.this.setDelay();
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Console.this.altCtrlDown = keyEvent.isAltDown() && keyEvent.isControlDown();
            }

            public void keyReleased(KeyEvent keyEvent) {
                Console.this.altCtrlDown = false;
            }
        };
        this.addKeyListener(keyAdapter);
        this.scrollPane.addKeyListener(keyAdapter);
        this.output.addKeyListener(keyAdapter);
        this.loggerComboBox.addKeyListener(keyAdapter);
        this.levelComboBox.addKeyListener(keyAdapter);
        this.apply.addKeyListener(keyAdapter);
        this.clear.addKeyListener(keyAdapter);
        this.save.addKeyListener(keyAdapter);
        this.addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                Console.this.altCtrlDown = false;
            }
        });
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.loggerComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.levelComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.delayTxt, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.apply, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.clear, gridBagConstraints);
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.save, gridBagConstraints);
        if (ConsoleSettings.SHOW_INPUT_FIELD.getValue()) {
            this.listeners = new ArrayList<ConsoleListener>();
            JTextField jTextField = new JTextField();
            jTextField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTextField jTextField = (JTextField)actionEvent.getSource();
                    String string = jTextField.getText().trim();
                    if (string.length() == 0) {
                        return;
                    }
                    jTextField.setText("");
                    try {
                        ConsoleWriter consoleWriter = new ConsoleWriter();
                        PrintWriter printWriter = new PrintWriter(consoleWriter);
                        for (ConsoleListener consoleListener : Console.this.listeners) {
                            if (!consoleListener.handleCommand(string, printWriter)) continue;
                            return;
                        }
                        Console.this.appendText("Unknown command: " + string + "\n");
                    }
                    catch (IOException iOException) {
                        Console.this.appendText(iOException.getMessage());
                    }
                }
            });
            this.addConsoleListener(new ConsoleListener(){

                public boolean handleCommand(final String string, final PrintWriter printWriter) throws IOException {
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                DHTManager dHTManager = GuiCoreMediator.getDHTManager();
                                MojitoDHT mojitoDHT = dHTManager.getMojitoDHT();
                                if (mojitoDHT == null) {
                                    printWriter.println("Mojito is not running");
                                    return;
                                }
                                Class<?> clazz = Class.forName("org.limewire.mojito.CommandHandler");
                                Method method = clazz.getMethod("handle", MojitoDHT.class, String.class, PrintWriter.class);
                                ((Boolean)method.invoke(null, mojitoDHT, string, printWriter)).booleanValue();
                            }
                            catch (SecurityException securityException) {
                                securityException.printStackTrace(printWriter);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                illegalArgumentException.printStackTrace(printWriter);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                classNotFoundException.printStackTrace(printWriter);
                            }
                            catch (NoSuchMethodException noSuchMethodException) {
                                noSuchMethodException.printStackTrace(printWriter);
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                illegalAccessException.printStackTrace(printWriter);
                            }
                            catch (InvocationTargetException invocationTargetException) {
                                invocationTargetException.printStackTrace(printWriter);
                            }
                            finally {
                                printWriter.flush();
                            }
                        }
                    };
                    new Thread(runnable).start();
                    return true;
                }
            });
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)jTextField, gridBagConstraints);
        }
        this.add("South", jPanel);
        this.updateTheme();
        ThemeMediator.addThemeObserver(this);
        this.refreshLoggers();
        this.attachLogs();
    }

    public void addConsoleListener(ConsoleListener consoleListener) {
        if (this.listeners != null && consoleListener != null) {
            this.listeners.add(consoleListener);
        }
    }

    private void attachLogs() {
        WriterAppender writerAppender = new WriterAppender((Layout)new PatternLayout(ConsoleSettings.CONSOLE_PATTERN_LAYOUT.getValue()), new ConsoleWriter());
        LogManager.getRootLogger().addAppender(writerAppender);
    }

    private void refreshLoggers() {
        Object object;
        LoggerRepository loggerRepository = LogManager.getLoggerRepository();
        Enumeration enumeration = loggerRepository.getCurrentLoggers();
        LoggerComboBoxModel loggerComboBoxModel = (LoggerComboBoxModel)this.loggerComboBox.getModel();
        int n = this.loggerComboBox.getSelectedIndex();
        LoggerNode loggerNode = n >= 0 ? loggerComboBoxModel.getLogger(n) : null;
        ArrayList<PackageNode> arrayList = new ArrayList<PackageNode>();
        HashMap<Object, PackageNode> hashMap = new HashMap<Object, PackageNode>();
        while (enumeration.hasMoreElements()) {
            object = (Logger)enumeration.nextElement();
            String string = PackageNode.getPackage((Logger)object);
            PackageNode packageNode = (PackageNode)hashMap.get(string);
            if (packageNode == null) {
                packageNode = new PackageNode(string);
                hashMap.put(string, packageNode);
                arrayList.add(packageNode);
            }
            packageNode.add((Logger)object);
        }
        Collections.sort(arrayList, new Comparator<PackageNode>(){

            @Override
            public int compare(PackageNode packageNode, PackageNode packageNode2) {
                return packageNode.getName().compareTo(packageNode2.getName());
            }
        });
        n = -1;
        object = new ArrayList();
        for (PackageNode packageNode : arrayList) {
            packageNode.sort();
            object.add(packageNode);
            if (n == -1 && packageNode.equals(loggerNode)) {
                n = object.size() - 1;
            }
            for (ClassNode classNode : packageNode.getNodes()) {
                object.add(classNode);
                if (n != -1 || !classNode.equals(loggerNode)) continue;
                n = object.size() - 1;
            }
        }
        loggerComboBoxModel.refreshLoggers((List)object);
        boolean bl = object.isEmpty();
        this.loggerComboBox.setEnabled(!bl);
        this.levelComboBox.setEnabled(!bl);
        this.apply.setEnabled(!bl);
        if (!bl) {
            this.loggerComboBox.setSelectedIndex(n >= 0 ? n : 0);
            this.selectLoggerLevel();
        }
    }

    private void selectLoggerLevel() {
        LoggerComboBoxModel loggerComboBoxModel = (LoggerComboBoxModel)this.loggerComboBox.getModel();
        LevelComboBoxModel levelComboBoxModel = (LevelComboBoxModel)this.levelComboBox.getModel();
        int n = this.loggerComboBox.getSelectedIndex();
        if (n < 0) {
            return;
        }
        Level level = Console.getLevel(loggerComboBoxModel.getLogger(n));
        levelComboBoxModel.setSelectedItem(level);
    }

    private void applyLevel() {
        Level level;
        this.setDelay();
        LoggerComboBoxModel loggerComboBoxModel = (LoggerComboBoxModel)this.loggerComboBox.getModel();
        LevelComboBoxModel levelComboBoxModel = (LevelComboBoxModel)this.levelComboBox.getModel();
        int n = this.loggerComboBox.getSelectedIndex();
        if (n < 0) {
            return;
        }
        LoggerNode loggerNode = loggerComboBoxModel.getLogger(n);
        Level level2 = Console.getLevel(loggerNode);
        int n2 = this.levelComboBox.getSelectedIndex();
        Level level3 = level = n2 > 0 ? levelComboBoxModel.getLevel(n2) : null;
        if (!level2.equals(level)) {
            loggerNode.setLevel(level);
            this.loggerComboBox.setSelectedIndex(n);
            loggerComboBoxModel.updateIndex(n);
        }
    }

    public void appendText(String string) {
        if (!this.output.isEnabled()) {
            return;
        }
        if (0 != this.delay) {
            this.delayBuf.append(string);
            return;
        }
        this.invokeLaterConsoleAppend(string);
    }

    public void clear() {
        this.output.setText(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            this.output.setEnabled(this.altCtrlDown);
            String string = this.output.getText().trim();
            String string2 = CommonUtils.getAllStackTraces();
            if (string.length() == 0 && string2.length() == 0) {
                return;
            }
            if (this.altCtrlDown) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("-- BEGIN STACK TRACES --\n");
                stringBuilder.append(string2.length() > 0 ? string2 : "NONE");
                stringBuilder.append("\n-- END STACK TRACES --\n");
                this.appendText(stringBuilder.toString());
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(new Date()).append("\n\n");
                Exception exception = new Exception(){

                    public void printStackTrace(PrintWriter printWriter) {
                    }
                };
                LocalClientInfo localClientInfo = localClientInfoFactory.createLocalClientInfo(exception, Thread.currentThread().getName(), "Console Log", false);
                stringBuilder.append(localClientInfo.toBugReport());
                stringBuilder.append("-- BEGIN STACK TRACES --\n");
                stringBuilder.append(string2.length() > 0 ? string2 : "NONE");
                stringBuilder.append("\n-- END STACK TRACES --\n");
                stringBuilder.append("\n-- BEGIN LOG --\n");
                stringBuilder.append(string.length() > 0 ? string : "NONE");
                stringBuilder.append("\n-- END LOG --\n");
                File file = FileChooserHandler.getSaveAsFile(GUIMediator.getAppFrame(), I18nMarker.marktr("Save As"), new File(FileChooserHandler.getLastInputDirectory(), "limewire-log.txt"));
                if (file == null) {
                    return;
                }
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                bufferedWriter.write(stringBuilder.toString());
                bufferedWriter.close();
            }
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        finally {
            this.output.setEnabled(true);
        }
    }

    public void invokeLaterConsoleAppend(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Console.this._appendText(string);
            }
        });
    }

    public void _appendText(String string) {
        this.output.append(string);
        int n = this.output.getDocument().getLength() - this.idealSize;
        if (n >= this.maxExcess) {
            this.output.replaceRange("", 0, n);
        }
        if (this.scroll) {
            this.output.setCaretPosition(this.output.getText().length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelay() {
        this.delay = this.delayTxt.getValue();
        if (0 == this.delay) {
            StringBuffer stringBuffer = this.delayBuf;
            synchronized (stringBuffer) {
                if (0 != this.delayBuf.length()) {
                    String string = this.delayBuf.toString();
                    this.delayBuf.delete(0, string.length());
                    this.invokeLaterConsoleAppend(string);
                }
            }
            if (this.delayTimer != null) {
                this.delayTimer.stop();
                this.delayTimer = null;
            }
        } else if (null == this.delayTimer) {
            this.delayTimer = new Timer(this.delay * 1000, new ActionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    if (0 == Console.this.delayBuf.length()) {
                        return;
                    }
                    StringBuffer stringBuffer = Console.this.delayBuf;
                    synchronized (stringBuffer) {
                        String string = Console.this.delayBuf.toString();
                        Console.this.delayBuf.delete(0, string.length());
                        Console.this._appendText(string);
                    }
                }
            });
            this.delayTimer.start();
        } else {
            this.delayTimer.setDelay(this.delay * 1000);
        }
    }

    public void updateTheme() {
        Color color = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.scrollPane.getViewport().setBackground(color);
    }

    private static final Level getLevel(LoggerNode loggerNode) {
        Level level = loggerNode.getLevel();
        if (level == null) {
            level = Level.OFF;
        }
        return level;
    }

    public static interface ConsoleListener {
        public boolean handleCommand(String var1, PrintWriter var2) throws IOException;
    }

    private static class ClassNode
    implements LoggerNode {
        private PackageNode parent;
        private Logger logger;

        private ClassNode(PackageNode packageNode, Logger logger) {
            this.parent = packageNode;
            this.logger = logger;
        }

        public PackageNode getParent() {
            return this.parent;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public Level getLevel() {
            return this.logger.getLevel();
        }

        public void setLevel(Level level) {
            this.logger.setLevel(level);
        }

        public boolean isLeaf() {
            return true;
        }

        public String getName() {
            return this.logger.getName();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof ClassNode)) {
                return false;
            }
            return this.getName().equals(((ClassNode)object).getName());
        }

        public String toString() {
            return this.getName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PackageNode
    implements LoggerNode {
        private String pkg;
        private List<ClassNode> classNodes = new ArrayList<ClassNode>();

        private PackageNode(String string) {
            this.pkg = string;
        }

        public void add(Logger logger) {
            this.classNodes.add(new ClassNode(this, logger));
        }

        @Override
        public Level getLevel() {
            return Level.OFF;
        }

        @Override
        public void setLevel(Level level) {
            for (int i = this.classNodes.size() - 1; i >= 0; --i) {
                this.classNodes.get(i).setLevel(level);
            }
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        public void sort() {
            Collections.sort(this.classNodes, new Comparator<ClassNode>(){

                @Override
                public int compare(ClassNode classNode, ClassNode classNode2) {
                    return classNode.getName().compareTo(classNode2.getName());
                }
            });
        }

        public List<ClassNode> getNodes() {
            return this.classNodes;
        }

        public int hashCode() {
            return this.pkg.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof PackageNode)) {
                return false;
            }
            return this.pkg.equals(((PackageNode)object).pkg);
        }

        @Override
        public String getName() {
            return this.pkg;
        }

        public String toString() {
            return this.getName();
        }

        private static String getPackage(Logger logger) {
            String string = logger.getName();
            int n = string.lastIndexOf(46);
            return n != -1 ? string.substring(0, n) + ".*" : string + ".*";
        }
    }

    private static interface LoggerNode {
        public boolean isLeaf();

        public Level getLevel();

        public void setLevel(Level var1);

        public String getName();
    }

    private class LevelComboBoxModel
    extends DefaultComboBoxModel {
        private final Level[] levels = new Level[]{Level.OFF, Level.ALL, Level.DEBUG, Level.ERROR, Level.FATAL, Level.INFO, Level.WARN};

        private LevelComboBoxModel() {
        }

        public int getSize() {
            return this.levels.length;
        }

        private Level getLevel(int n) {
            return this.levels[n];
        }

        public Object getElementAt(int n) {
            return this.getLevel(n).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggerComboBoxModel
    extends DefaultComboBoxModel {
        private static final String SPACER = "    ";
        private List<LoggerNode> nodes = Collections.emptyList();

        private LoggerComboBoxModel() {
        }

        private void updateIndex(int n) {
            this.fireContentsChanged(this, n, n);
        }

        private void refreshLoggers(List<LoggerNode> list) {
            this.nodes = list;
            this.fireContentsChanged(this, 0, list.size());
        }

        @Override
        public int getSize() {
            return this.nodes.size();
        }

        private LoggerNode getLogger(int n) {
            return this.nodes.get(n);
        }

        @Override
        public Object getElementAt(int n) {
            LoggerNode loggerNode = this.getLogger(n);
            Level level = Console.getLevel(loggerNode);
            if (level.equals(Level.OFF)) {
                if (loggerNode.isLeaf()) {
                    return SPACER + loggerNode.getName();
                }
                return loggerNode.getName();
            }
            if (loggerNode.isLeaf()) {
                return SPACER + loggerNode.getName() + " [" + level + "]";
            }
            return loggerNode.getName();
        }
    }

    private final class ConsoleWriter
    extends Writer {
        private StringBuilder buffer = new StringBuilder();

        private ConsoleWriter() {
        }

        public void write(char[] cArray, int n, int n2) {
            this.buffer.append(cArray, n, n2);
        }

        public void close() {
            this.buffer = null;
        }

        public void flush() {
            Console.this.appendText(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }
}

