/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.KeyProcessingTextField;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.text.Document;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.collection.StringTrieSet;

public class AutoCompleteTextField
extends KeyProcessingTextField {
    protected AutoCompleteDictionary dict;

    public AutoCompleteTextField() {
    }

    public AutoCompleteTextField(Document document, String string, int n) {
        super(document, string, n);
    }

    public AutoCompleteTextField(int n) {
        super(n);
    }

    public AutoCompleteTextField(String string) {
        super(string);
    }

    public AutoCompleteTextField(String string, int n) {
        super(string, n);
    }

    public void setDictionary(AutoCompleteDictionary autoCompleteDictionary) {
        if (this.dict == null) {
            this.setUp();
        }
        this.dict = autoCompleteDictionary;
    }

    public AutoCompleteDictionary getDictionary() {
        return this.dict;
    }

    public AutoCompleteDictionary createDefaultDictionary() {
        return new StringTrieSet(true);
    }

    public void setAutoComplete(boolean bl) {
        UISettings.AUTOCOMPLETE_ENABLED.setValue(bl);
    }

    public boolean getAutoComplete() {
        return UISettings.AUTOCOMPLETE_ENABLED.getValue();
    }

    public void addToDictionary() {
        if (!this.getAutoComplete()) {
            return;
        }
        if (this.dict == null) {
            this.setUp();
            this.dict = this.createDefaultDictionary();
        }
        this.dict.addEntry(this.getText().trim());
    }

    public void addToDictionary(String string) {
        if (!this.getAutoComplete()) {
            return;
        }
        if (this.dict == null) {
            this.setUp();
            this.dict = this.createDefaultDictionary();
        }
        this.dict.addEntry(string.trim());
    }

    protected void setUp() {
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                int n = keyEvent.getKeyCode();
                if (n == 127 || c == '\uffff' || n == 8) {
                    return;
                }
                AutoCompleteTextField.this.autoCompleteInput();
            }
        });
    }

    public void autoCompleteInput() {
        if (this.getSelectionStart() != this.getSelectionEnd()) {
            this.setText(this.getText().substring(0, this.getSelectionStart()));
        }
        String string = this.getText();
        String string2 = this.lookup(string);
        int n = string.length();
        if (string2 != null && n < string2.length()) {
            this.setText(string + string2.substring(n));
            this.setSelectionStart(string.length());
            this.setSelectionEnd(this.getText().length());
        }
    }

    protected String lookup(String string) {
        if (this.dict != null && this.getAutoComplete() && !string.equals("")) {
            return this.dict.lookup(string);
        }
        return null;
    }
}

