/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLDocFilter
extends KeywordFilter {
    private Map<String, List<String>> disallowedFieldValues = new HashMap<String, List<String>>();
    private Map<String, List<String>> disallowedExactFieldValues = new HashMap<String, List<String>>();

    public void addDisallowedEntries(String string, List<String> list) {
        List<String> list2 = this.disallowedFieldValues.get(string);
        if (list2 == null) {
            list2 = new ArrayList<String>(list);
            this.disallowedFieldValues.put(string, list2);
        } else {
            list2.addAll(list);
        }
    }

    public void addDisallowedExactEntries(String string, List<String> list) {
        List<String> list2 = this.disallowedExactFieldValues.get(string);
        if (list2 == null) {
            list2 = new ArrayList<String>(list);
            this.disallowedExactFieldValues.put(string, list2);
        } else {
            list2.addAll(list);
        }
    }

    @Override
    public void disallowAdult() {
        this.addDisallowedEntries("videos__video__type__", Arrays.asList("adult"));
        this.addDisallowedEntries("videos__video__rating__", Arrays.asList("adult"));
        this.addDisallowedExactEntries("videos__video__rating__", Arrays.asList("r", "nc-17"));
        super.disallowAdult();
    }

    @Override
    boolean allow(QueryReply queryReply) {
        if (!super.allow(queryReply)) {
            return false;
        }
        try {
            for (Response response : queryReply.getResultsAsList()) {
                LimeXMLDocument limeXMLDocument = response.getDocument();
                if (limeXMLDocument == null || this.allowDoc(limeXMLDocument)) continue;
                return false;
            }
            return true;
        }
        catch (BadPacketException badPacketException) {
            return false;
        }
    }

    protected boolean allowDoc(LimeXMLDocument limeXMLDocument) {
        String string;
        for (Map.Entry<String, List<String>> entry : this.disallowedFieldValues.entrySet()) {
            string = limeXMLDocument.getValue(entry.getKey());
            if (string == null) continue;
            string = string.toLowerCase(Locale.US);
            for (String string2 : entry.getValue()) {
                if (!string.contains(string2)) continue;
                return false;
            }
        }
        for (Map.Entry<String, List<String>> entry : this.disallowedExactFieldValues.entrySet()) {
            string = limeXMLDocument.getValue(entry.getKey());
            if (string == null) continue;
            string = string.toLowerCase(Locale.US);
            for (String string2 : entry.getValue()) {
                if (!string.equals(string2)) continue;
                return false;
            }
        }
        return true;
    }
}

